/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sdo.tools;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XSDHelper;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.DefaultValueWriter;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.tuscany.sdo.generate.JavaGenerator;
import org.apache.tuscany.sdo.generate.XSD2JavaGenerator;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.XSDHelperImpl;
import org.apache.ws.commons.schema.XmlSchema;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class SDODatabinding
extends XSD2JavaGenerator
implements DataBindingProfile {
    private static final String DATABINDING_DYNAMIC_SDO = "sdo-dynamic";
    private TypeHelper typeHelper;
    private XSDHelper xsdHelper;
    private boolean dynamic;
    private ExtendedMetaData extendedMetaData;
    private GenModel genModel;
    private Map<EClassifier, GenClass> genClasses = new HashMap<EClassifier, GenClass>();
    private SchemaCollection schemaCollection;
    private EPackage.Registry packageRegistry;

    public void initialize(ToolContext context) throws ToolException {
        context.put("databinding-class", (Object)"org.apache.cxf.sdo.SDODataBinding.class");
        String databinding = (String)context.get("databinding");
        if (DATABINDING_DYNAMIC_SDO.equalsIgnoreCase(databinding)) {
            this.dynamic = true;
        }
        generatedPackages = null;
        String outputDir = (String)context.get("outputdir");
        String pkg = context.getPackageName();
        if (outputDir == null) {
            String wsdl = (String)context.get("wsdlLocation");
            try {
                outputDir = new File(new URI(wsdl)).getParentFile().getAbsolutePath();
            }
            catch (URISyntaxException e) {
                outputDir = new File(".").getAbsolutePath();
            }
        }
        File targetDir = new File(outputDir);
        targetDir.mkdirs();
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-targetDirectory");
        argList.add(targetDir.getAbsolutePath());
        if (pkg != null) {
            argList.add("-javaPackage");
            argList.add(pkg);
        }
        this.schemaCollection = (SchemaCollection)context.get("xmlSchemaCollection");
        argList.add("");
        String[] args = argList.toArray(new String[argList.size()]);
        this.packageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        this.extendedMetaData = new BasicExtendedMetaData(this.packageRegistry);
        HelperContextImpl hc = new HelperContextImpl(this.extendedMetaData, false);
        this.xsdHelper = hc.getXSDHelper();
        this.typeHelper = hc.getTypeHelper();
        this.processArguments(args);
        ((XSDHelperImpl)this.xsdHelper).setRedefineBuiltIn(this.generateBuiltIn);
        for (XmlSchema schema : this.schemaCollection.getXmlSchemas()) {
            if (schema.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) continue;
            StringWriter writer = new StringWriter();
            schema.write((Writer)writer);
            this.xsdHelper.define((Reader)new StringReader(writer.toString()), schema.getSourceURI());
        }
    }

    public void generate(ToolContext context) throws ToolException {
        Map ns2pkgMap = context.getNamespacePackageMap();
        Map<String, JavaGenerator.PackageInfo> packageInfoTable = this.createPackageInfoTable(this.schemaCollection, ns2pkgMap);
        ClassCollector classCollector = (ClassCollector)context.get(ClassCollector.class);
        try {
            if (!this.dynamic) {
                this.genModel = SDODatabinding.generatePackages((Collection)this.packageRegistry.values(), (String)this.targetDirectory, new Hashtable<String, JavaGenerator.PackageInfo>(packageInfoTable), (int)this.genOptions, (boolean)this.allNamespaces);
                List packages = CastUtils.cast((List)this.genModel.getGenPackages());
                for (GenPackage genPackage : packages) {
                    List classes = CastUtils.cast((List)genPackage.getGenClasses());
                    for (GenClass genClass : classes) {
                        this.genClasses.put((EClassifier)genClass.getEcoreClass(), genClass);
                        String s = genClass.getQualifiedClassName();
                        String p = s.substring(0, s.lastIndexOf(46));
                        s = s.substring(s.lastIndexOf(46) + 1);
                        classCollector.addTypesClassName(p, s, genClass.getQualifiedClassName());
                        p = genClass.getGenPackage().getInterfacePackageName();
                        s = genClass.getInterfaceName();
                        classCollector.addTypesClassName(p, s, p + "." + s);
                    }
                    String p = genPackage.getInterfacePackageName();
                    String s = genPackage.getFactoryInterfaceName();
                    classCollector.addTypesClassName(p, s, p + "." + s);
                    p = genPackage.getClassPackageName();
                    s = genPackage.getFactoryClassName();
                    classCollector.addTypesClassName(p, s, p + "." + s);
                }
            }
        }
        catch (Exception e) {
            throw new ToolException((Throwable)e);
        }
    }

    private Map<String, JavaGenerator.PackageInfo> createPackageInfoTable(SchemaCollection schemas, Map<String, String> ns2PkgMap) {
        HashMap<String, JavaGenerator.PackageInfo> packageInfoTable = new HashMap<String, JavaGenerator.PackageInfo>();
        if (ns2PkgMap != null && !ns2PkgMap.isEmpty()) {
            for (Map.Entry<String, String> e : ns2PkgMap.entrySet()) {
                packageInfoTable.put(e.getKey(), new JavaGenerator.PackageInfo(e.getValue(), null, e.getKey(), null));
            }
        } else {
            for (XmlSchema schema : schemas.getXmlSchemas()) {
                packageInfoTable.put(schema.getTargetNamespace(), new JavaGenerator.PackageInfo(this.javaPackage, this.prefix, schema.getTargetNamespace(), null));
            }
        }
        return packageInfoTable;
    }

    public String getType(QName qName, boolean element) {
        Property property;
        Type type = null;
        if (element && (property = this.xsdHelper.getGlobalProperty(qName.getNamespaceURI(), qName.getLocalPart(), true)) != null) {
            type = property.getType();
        }
        if (type == null) {
            type = this.typeHelper.getType(qName.getNamespaceURI(), qName.getLocalPart());
        }
        if (type != null) {
            return this.getClassName(type);
        }
        return DataObject.class.getName();
    }

    private String getClassName(Type type) {
        EClassifier eClassifier = (EClassifier)type;
        String name = eClassifier.getInstanceClassName();
        if (name != null) {
            return name;
        }
        if (this.genModel == null) {
            if (this.dynamic) {
                return DataObject.class.getName();
            }
            return type.getName();
        }
        if (eClassifier instanceof EClass) {
            GenClass genEClass = this.genClasses.get(eClassifier);
            if (genEClass != null) {
                name = genEClass.getGenPackage().getInterfacePackageName() + '.' + genEClass.getInterfaceName();
            }
        } else {
            name = eClassifier.getInstanceClass().getName();
        }
        return name;
    }

    public String getWrappedElementType(QName wrapperElement, QName item) {
        Property itemProp;
        Type type = null;
        Property property = this.xsdHelper.getGlobalProperty(wrapperElement.getNamespaceURI(), wrapperElement.getLocalPart(), true);
        if (property != null && (itemProp = (type = property.getType()).getProperty(item.getLocalPart())) != null) {
            type = itemProp.getType();
        }
        if (type != null) {
            return this.getClassName(type);
        }
        return DataObject.class.getName();
    }

    public DefaultValueWriter createDefaultValueWriter(QName qName, boolean b) {
        return null;
    }

    public DefaultValueWriter createDefaultValueWriterForWrappedElement(QName qName, QName qName1) {
        return null;
    }
}

