/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.command;

import com.nortel.rc.command.Command;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.springframework.core.io.ClassPathResource;

public class GetServerDetailsCommand
extends Command {
    private String endpointFilename;
    private static final Logger LOG = Logger.getLogger(GetServerDetailsCommand.class);

    @Override
    public void execute(Map<String, Object> map) throws Exception {
        ClassPathResource classPathResource = new ClassPathResource(this.getEndpointFilename());
        System.out.println("Using file at: " + classPathResource.getURL().toURI());
        if (LOG.isInfoEnabled()) {
            LOG.log((Priority)Level.INFO, (Object)("Using file at: " + classPathResource.getURL().toURI()));
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(classPathResource.getFile())));
            StringTokenizer stringTokenizer = new StringTokenizer(String.valueOf(bufferedReader.readLine()).trim(), ":");
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken().substring(2);
            String string3 = stringTokenizer.nextToken();
            if (LOG.isInfoEnabled()) {
                LOG.log((Priority)Level.INFO, (Object)("execute : protocol [" + string + "] Server [" + string2 + "] Port [" + string3 + "]"));
            }
            this.getRefClient().updateServerSettings(string2, string3, string.equalsIgnoreCase("https"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.log((Priority)Level.WARN, (Object)"execute : Failed to find endpoint file);");
            throw new Exception(fileNotFoundException);
        }
        catch (IOException iOException) {
            LOG.log((Priority)Level.WARN, (Object)"execute : Failed to read endpoint file);");
            throw new Exception(iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                LOG.log((Priority)Level.WARN, (Object)"execute : Failed to close endpoint file reader!);");
            }
        }
    }

    public String getEndpointFilename() {
        return this.endpointFilename;
    }

    public void setEndpointFilename(String string) {
        this.endpointFilename = string;
    }
}

