/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.IRoutePointConnectionServiceDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionCapabilitiesTO;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.routepointconnectionservice.RoutePointConnectionService;
import com.nortel.soa.oi.cct.routepointconnectionservice.SOAOICCTRoutePointConnectionService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.Connection;
import com.nortel.soa.oi.cct.types.MediaTreatment;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.GiveMediaTreatmentRequest;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.RoutePointRetrieveRequest;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.RouteRequest;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.RouteResponse;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RoutePointConnectionServiceDAO
extends ServiceDAO
implements IRoutePointConnectionServiceDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.RoutePointConnectionServiceDAO");
    private String endPoint = null;

    @Override
    public CallResult retrieve(AddressTO addressTO, ConnectionTO connectionTO, String string) throws DAOException {
        Object object;
        String string2 = "retrieve():";
        RoutePointRetrieveRequest routePointRetrieveRequest = new RoutePointRetrieveRequest();
        SsoToken ssoToken = new SsoToken();
        if (addressTO != null) {
            object = new Address();
            ((Address)object).setAddressName(addressTO.getAddressName());
            ((Address)object).setAddressType(AddressType.valueOf(addressTO.getAddressType()));
            routePointRetrieveRequest.setAddress((Address)object);
        }
        if (connectionTO != null) {
            object = new Connection();
            ((Connection)object).setConnectionId(connectionTO.getConnectionId());
            routePointRetrieveRequest.setRoutePointConnection((Connection)object);
        }
        ssoToken.setToken(string);
        routePointRetrieveRequest.setSsoToken(ssoToken);
        try {
            this.getPort().routePointRetrieve(routePointRetrieveRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        return null;
    }

    @Override
    public CallResult route(String string, ConnectionTO connectionTO, String string2) throws DAOException {
        Object object;
        String string3 = "route():";
        RouteRequest routeRequest = new RouteRequest();
        RouteResponse routeResponse = null;
        SsoToken ssoToken = new SsoToken();
        if (string != null) {
            routeRequest.setDestinationAddress(string);
        }
        if (connectionTO != null) {
            object = new Connection();
            ((Connection)object).setConnectionId(connectionTO.getConnectionId());
            routeRequest.setRoutePointConnection((Connection)object);
        }
        ssoToken.setToken(string2);
        routeRequest.setSsoToken(ssoToken);
        try {
            routeResponse = this.getPort().route(routeRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string3, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string3 + " sso[" + string2 + "] endpoint : " + this.endPoint));
        }
        object = null;
        if (routeResponse != null && routeResponse.getConnection() != null) {
            object = new CallResult();
            Connection connection = routeResponse.getConnection();
            ConnectionTO connectionTO2 = new ConnectionTO();
            connectionTO2.setConnectionId(connection.getConnectionId());
            ((CallResult)object).setObject(connectionTO2);
        }
        return object;
    }

    @Override
    public CallResult giveMediaTreatment(String string, String string2, ConnectionTO connectionTO, String string3, String string4) throws DAOException {
        String string5 = "giveMediaTreatment():";
        GiveMediaTreatmentRequest giveMediaTreatmentRequest = new GiveMediaTreatmentRequest();
        MediaTreatment mediaTreatment = new MediaTreatment();
        Connection connection = new Connection();
        SsoToken ssoToken = new SsoToken();
        mediaTreatment.setInterruptible(true);
        mediaTreatment.setTreatmentAddress("");
        mediaTreatment.setTreatmentParameter(null);
        mediaTreatment.setTreatmentTerminal(null);
        mediaTreatment.setType(string3);
        connection.setConnectionId(connectionTO.getConnectionId());
        ssoToken.setToken(string4);
        giveMediaTreatmentRequest.setSsoToken(ssoToken);
        giveMediaTreatmentRequest.setConnection(connection);
        giveMediaTreatmentRequest.setTreatment(mediaTreatment);
        try {
            this.getPort().giveMediaTreatment(giveMediaTreatmentRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string5, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string5 + " sso[" + string4 + "] endpoint : " + this.endPoint));
        }
        return null;
    }

    @Override
    public CallResult getCapabilities(ConnectionTO connectionTO, String string) throws DAOException {
        logger.log((Priority)Level.WARN, (Object)"getCapabilities(): we don't implement capabilities for route point connections");
        ConnectionCapabilitiesTO connectionCapabilitiesTO = new ConnectionCapabilitiesTO();
        CallResult callResult = new CallResult();
        callResult.setObject(connectionCapabilitiesTO);
        return callResult;
    }

    public RoutePointConnectionService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCTRoutePointConnectionService(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(RoutePointConnectionService.class);
        object = (RoutePointConnectionService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }
}

