/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.ITerminalServiceDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ForwardInstructionTO;
import com.nortel.rc.dto.TerminalCapabilitiesTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.faults.GetCapabilitiesException;
import com.nortel.soa.oi.cct.faults.GetContactTypesException;
import com.nortel.soa.oi.cct.faults.GetForwardingException;
import com.nortel.soa.oi.cct.terminalservice.SOAOICCTTerminalService;
import com.nortel.soa.oi.cct.terminalservice.TerminalService;
import com.nortel.soa.oi.cct.types.Forwarding;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalCapabilities;
import com.nortel.soa.oi.cct.types.TerminalType;
import com.nortel.soa.oi.cct.types.terminalservice.GetContactTypesResponse;
import com.nortel.soa.oi.cct.types.terminalservice.GetDoNotDisturbResponse;
import com.nortel.soa.oi.cct.types.terminalservice.GetForwardingResponse;
import com.nortel.soa.oi.cct.types.terminalservice.GetTerminalCapabilitiesResponse;
import com.nortel.soa.oi.cct.types.terminalservice.IsForwardedResponse;
import com.nortel.soa.oi.cct.types.terminalservice.SetDoNotDisturbTerminalRequest;
import com.nortel.soa.oi.cct.types.terminalservice.SetForwardingTerminalRequest;
import com.nortel.soa.oi.cct.types.terminalservice.TerminalRequest;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TerminalServiceDAO
extends ServiceDAO
implements ITerminalServiceDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.TerminalServiceDAO");
    private String endPoint = null;

    @Override
    public CallResult getCapabilities(TerminalTO terminalTO, String string) throws DAOException {
        Object object;
        String string2 = "getCapabilities():";
        TerminalRequest terminalRequest = new TerminalRequest();
        TerminalCapabilities terminalCapabilities = null;
        SsoToken ssoToken = new SsoToken();
        Terminal terminal = new Terminal();
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            object = this.getPort().getCapabilities(terminalRequest);
            if (object == null) {
                throw new GetCapabilitiesException("NULL response received");
            }
            terminalCapabilities = ((GetTerminalCapabilitiesResponse)object).getTerminalCapabilities();
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        object = new TerminalCapabilitiesTO();
        ((TerminalCapabilitiesTO)object).setCanConference(terminalCapabilities.isCanConference());
        ((TerminalCapabilitiesTO)object).setCanDoNotDisturb(terminalCapabilities.isCanDoNotDisturb());
        ((TerminalCapabilitiesTO)object).setCanOriginate(terminalCapabilities.isCanOriginate());
        ((TerminalCapabilitiesTO)object).setCanTransfer(terminalCapabilities.isCanTransfer());
        ((TerminalCapabilitiesTO)object).setCanForward(terminalCapabilities.isCanForward());
        CallResult callResult = new CallResult();
        callResult.setObject(object);
        return callResult;
    }

    @Override
    public CallResult getDoNotDisturb(TerminalTO terminalTO, String string) throws DAOException {
        GetDoNotDisturbResponse getDoNotDisturbResponse;
        String string2 = "getDoNotDisturb():";
        TerminalRequest terminalRequest = new TerminalRequest();
        SsoToken ssoToken = new SsoToken();
        Terminal terminal = new Terminal();
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            getDoNotDisturbResponse = this.getPort().getDoNotDisturb(terminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setObject(getDoNotDisturbResponse != null ? getDoNotDisturbResponse.isDoNotDisturb() : false);
        return callResult;
    }

    @Override
    public CallResult setDoNotDisturb(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "setDoNotDisturb():";
        SetDoNotDisturbTerminalRequest setDoNotDisturbTerminalRequest = new SetDoNotDisturbTerminalRequest();
        SsoToken ssoToken = new SsoToken();
        Terminal terminal = new Terminal();
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        setDoNotDisturbTerminalRequest.setTerminal(terminal);
        setDoNotDisturbTerminalRequest.setSsoToken(ssoToken);
        setDoNotDisturbTerminalRequest.setDoNotDisturb(terminalTO.isDoNotDisturb());
        try {
            this.getPort().setDoNotDisturb(setDoNotDisturbTerminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult setForwarding(TerminalTO terminalTO, List<ForwardInstructionTO> list, String string) throws DAOException {
        String string2 = "setForwarding():";
        SetForwardingTerminalRequest setForwardingTerminalRequest = new SetForwardingTerminalRequest();
        SsoToken ssoToken = new SsoToken();
        Terminal terminal = new Terminal();
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        setForwardingTerminalRequest.setTerminal(terminal);
        setForwardingTerminalRequest.setSsoToken(ssoToken);
        for (ForwardInstructionTO forwardInstructionTO : list) {
            Forwarding forwarding = new Forwarding();
            forwarding.setCaller(forwardInstructionTO.getFrom());
            forwarding.setDestinationAddress(forwardInstructionTO.getForwardTo());
            forwarding.setType(1);
            forwarding.setWhichCalls(1);
            setForwardingTerminalRequest.getForwarding().add(forwarding);
        }
        try {
            this.getPort().setForwarding(setForwardingTerminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult getForwarding(TerminalTO terminalTO, String string) throws DAOException {
        GetForwardingResponse getForwardingResponse;
        String string2 = "getForwarding():";
        TerminalRequest terminalRequest = new TerminalRequest();
        ArrayList<ForwardInstructionTO> arrayList = new ArrayList<ForwardInstructionTO>();
        SsoToken ssoToken = new SsoToken();
        Terminal terminal = new Terminal();
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            getForwardingResponse = this.getPort().getForwarding(terminalRequest);
            if (getForwardingResponse == null) {
                throw new GetForwardingException("NULL response received");
            }
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        for (Forwarding forwarding : getForwardingResponse.getForwarding()) {
            ForwardInstructionTO forwardInstructionTO = new ForwardInstructionTO();
            forwardInstructionTO.setForwardTo(forwarding.getDestinationAddress());
            forwardInstructionTO.setFrom(forwarding.getCaller());
            arrayList.add(forwardInstructionTO);
        }
        CallResult callResult = new CallResult();
        callResult.setObject(arrayList);
        return callResult;
    }

    @Override
    public CallResult isForwarded(TerminalTO terminalTO, String string) throws DAOException {
        IsForwardedResponse isForwardedResponse;
        String string2 = "isForwarded():";
        TerminalRequest terminalRequest = new TerminalRequest();
        SsoToken ssoToken = new SsoToken();
        Terminal terminal = new Terminal();
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            isForwardedResponse = this.getPort().isForwarded(terminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setObject(isForwardedResponse != null ? isForwardedResponse.isIsForwarded() : false);
        return callResult;
    }

    @Override
    public CallResult cancelForwarding(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "cancelForwarding():";
        TerminalRequest terminalRequest = new TerminalRequest();
        SsoToken ssoToken = new SsoToken();
        Terminal terminal = new Terminal();
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            this.getPort().cancelForwarding(terminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        return callResult;
    }

    @Override
    public CallResult getContactTypes(TerminalTO terminalTO, String string) throws DAOException {
        Object object;
        String string2 = "getContactTypes():";
        TerminalRequest terminalRequest = new TerminalRequest();
        List<String> list = null;
        SsoToken ssoToken = new SsoToken();
        Terminal terminal = new Terminal();
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            object = this.getPort().getContactTypes(terminalRequest);
            if (object == null) {
                throw new GetContactTypesException("NULL response received");
            }
            list = ((GetContactTypesResponse)object).getContactTypes();
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        object = new CallResult();
        ((CallResult)object).setObject(list);
        return object;
    }

    public TerminalService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCTTerminalService(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(TerminalService.class);
        object = (TerminalService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }
}

