/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing;

import java.io.Serializable;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public abstract class AbstractTracingProvider {
    protected static String getSpanIdHeader() {
        return AbstractTracingProvider.getHeaderOrDefault("org.apache.cxf.tracing.header.span_id", "X-Span-Id");
    }

    private static String getHeaderOrDefault(String property, String fallback) {
        String name;
        Object header;
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null && (header = message.getContextualProperty(property)) instanceof String && !StringUtils.isEmpty((String)(name = (String)header))) {
            return name;
        }
        return fallback;
    }

    protected String buildSpanDescription(String path, String method) {
        if (StringUtils.isEmpty((String)method)) {
            return path;
        }
        return method + " " + path;
    }

    protected static class TraceScopeHolder<T>
    implements Serializable {
        private static final long serialVersionUID = -5985783659818936359L;
        private final T scope;
        private final boolean detached;

        public TraceScopeHolder(T scope, boolean detached) {
            this.scope = scope;
            this.detached = detached;
        }

        public T getScope() {
            return this.scope;
        }

        public boolean isDetached() {
            return this.detached;
        }
    }
}

