/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.Alias;
import org.apache.cxf.binding.corba.wsdl.Anonstring;
import org.apache.cxf.binding.corba.wsdl.Anonwstring;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

public class StringVisitor
extends VisitorBase {
    private AST stringNode = null;
    private AST boundNode = null;
    private AST identifierNode;
    private Scope stringScopedName;

    public StringVisitor(Scope scope, Definition definition, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor, AST identifierNodeRef) {
        super(scope, definition, schemaRef, wsdlVisitor);
        this.identifierNode = identifierNodeRef;
        this.stringScopedName = null;
    }

    public static boolean accept(AST node) {
        return node.getType() == 63 || node.getType() == 64;
    }

    public static boolean isBounded(AST node) {
        return node.getFirstChild() != null;
    }

    @Override
    public void visit(AST node) {
        String constValue;
        this.stringNode = node;
        this.boundNode = this.stringNode.getFirstChild();
        if (this.boundNode != null && (constValue = TypesUtils.getConstValueByName(this.boundNode, this.typeMap)) != null) {
            this.boundNode.setText(constValue);
        }
        if (this.identifierNode == null) {
            this.stringScopedName = TypesUtils.generateAnonymousScopedName(this.getScope(), this.schema);
        } else if (this.identifierNode.getFirstChild() == null) {
            this.stringScopedName = new Scope(this.getScope(), this.identifierNode);
        } else {
            Scope anonScope = new Scope(this.getScope(), this.identifierNode);
            this.stringScopedName = TypesUtils.generateAnonymousScopedName(anonScope, this.schema);
            this.identifierNode = null;
        }
        if (this.boundNode != null && !this.wsdlVisitor.getBoundedStringOverride()) {
            if (this.identifierNode != null) {
                this.visitBoundedString();
            } else {
                this.visitAnonBoundedString();
            }
        } else {
            this.visitUnboundedString();
        }
    }

    private void visitAnonBoundedString() {
        XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(this.schema, true);
        simpleType.setName(this.stringScopedName.toString());
        XmlSchemaSimpleTypeRestriction restriction = new XmlSchemaSimpleTypeRestriction();
        restriction.setBaseTypeName(Constants.XSD_STRING);
        XmlSchemaMaxLengthFacet maxLengthFacet = new XmlSchemaMaxLengthFacet();
        maxLengthFacet.setValue((Object)this.boundNode.toString());
        restriction.getFacets().add(maxLengthFacet);
        simpleType.setContent((XmlSchemaSimpleTypeContent)restriction);
        this.setSchemaType((XmlSchemaType)simpleType);
        Anonstring anon = null;
        if (this.stringNode.getType() == 63) {
            Anonstring anonstring = new Anonstring();
            anonstring.setQName(new QName(this.typeMap.getTargetNamespace(), this.stringScopedName.toString()));
            anonstring.setBound(Long.parseLong(this.boundNode.toString()));
            anonstring.setType(simpleType.getQName());
            anon = anonstring;
        } else if (this.stringNode.getType() == 64) {
            Anonwstring anonwstring = new Anonwstring();
            anonwstring.setQName(new QName(this.typeMap.getTargetNamespace(), this.stringScopedName.toString()));
            anonwstring.setBound(Long.parseLong(this.boundNode.toString()));
            anonwstring.setType(simpleType.getQName());
            anon = anonwstring;
        } else {
            throw new RuntimeException("StringVisitor attempted to visit an invalid node");
        }
        this.typeMap.getStructOrExceptionOrUnion().add(anon);
        this.setCorbaType((CorbaType)anon);
    }

    private void visitBoundedString() {
        XmlSchemaSimpleType simpleType = new XmlSchemaSimpleType(this.schema, true);
        simpleType.setName(this.stringScopedName.toString());
        XmlSchemaSimpleTypeRestriction restriction = new XmlSchemaSimpleTypeRestriction();
        restriction.setBaseTypeName(Constants.XSD_STRING);
        XmlSchemaMaxLengthFacet maxLengthFacet = new XmlSchemaMaxLengthFacet();
        maxLengthFacet.setValue((Object)this.boundNode.toString());
        restriction.getFacets().add(maxLengthFacet);
        simpleType.setContent((XmlSchemaSimpleTypeContent)restriction);
        this.setSchemaType((XmlSchemaType)simpleType);
        Scope anonstringScopedName = new Scope(this.getScope(), "_Anon1_" + this.stringScopedName.tail());
        String anonstringName = anonstringScopedName.toString();
        Anonstring anon = null;
        if (this.stringNode.getType() == 63) {
            Anonstring anonstring = new Anonstring();
            anonstring.setQName(new QName(this.typeMap.getTargetNamespace(), anonstringName));
            anonstring.setBound(Long.valueOf(this.boundNode.toString()).longValue());
            anonstring.setType(simpleType.getQName());
            anon = anonstring;
        } else if (this.stringNode.getType() == 64) {
            Anonwstring anonwstring = new Anonwstring();
            anonwstring.setQName(new QName(this.typeMap.getTargetNamespace(), anonstringName));
            anonwstring.setBound(Long.valueOf(this.boundNode.toString()).longValue());
            anonwstring.setType(simpleType.getQName());
            anon = anonwstring;
        } else {
            throw new RuntimeException("StringVisitor attempted to visit an invalid node");
        }
        this.typeMap.getStructOrExceptionOrUnion().add(anon);
        Alias alias = new Alias();
        alias.setQName(new QName(this.typeMap.getTargetNamespace(), this.stringScopedName.toString()));
        alias.setBasetype(anon.getQName());
        alias.setType(simpleType.getQName());
        alias.setRepositoryID(this.stringScopedName.toIDLRepositoryID());
        this.setCorbaType((CorbaType)alias);
    }

    private void visitUnboundedString() {
        this.setSchemaType(this.schemas.getTypeByQName(Constants.XSD_STRING));
        CorbaType corbaString = new CorbaType();
        if (this.stringNode.getType() == 63) {
            corbaString.setQName(CorbaConstants.NT_CORBA_STRING);
            corbaString.setName(CorbaConstants.NT_CORBA_STRING.getLocalPart());
        } else if (this.stringNode.getType() == 64) {
            corbaString.setQName(CorbaConstants.NT_CORBA_WSTRING);
            corbaString.setName(CorbaConstants.NT_CORBA_WSTRING.getLocalPart());
        } else {
            throw new RuntimeException("StringVisitor attempted to visit an invalid node");
        }
        corbaString.setType(Constants.XSD_STRING);
        this.setCorbaType(corbaString);
    }
}

