/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.command;

import com.nortel.rc.command.Command;
import com.nortel.rc.dao.IAddressServiceDAO;
import com.nortel.rc.dao.IAgentTerminalServiceDAO;
import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IConnectionServiceDAO;
import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dao.INotificationDAO;
import com.nortel.rc.dao.IRoutePointAddressServiceDAO;
import com.nortel.rc.dao.ITerminalConnectionServiceDAO;
import com.nortel.rc.dao.ITerminalServiceDAO;
import com.nortel.rc.dao.IUserServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.StateEventTO;
import com.nortel.rc.dto.StateSummaryTO;
import com.nortel.rc.dto.TerminalCapabilitiesTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.dto.UserContextDO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CCTLoginCommand
extends Command {
    private IContactDAO contactDAO;
    private INotificationDAO notificationDAO;
    private ICapabilitiesFacade capabilitiesFacade;
    private IAgentTerminalServiceDAO agentTerminalServiceDAO;
    private ITerminalServiceDAO terminalServiceDAO;
    private IContactServiceDAO contactServiceDAO;
    private IAddressServiceDAO addressServiceDAO;
    private IRoutePointAddressServiceDAO routePointAddressServiceDAO;
    private IConnectionServiceDAO connectionServiceDAO;
    private ITerminalConnectionServiceDAO terminalConnectionServiceDAO;
    private IUserServiceDAO userServiceDAO;
    UserContextDO userContext = new UserContextDO();
    List<TerminalTO> terminals = null;
    List<AddressTO> unmappedAddresses = null;
    List<StateEventTO> currentStateEvents = new ArrayList<StateEventTO>();

    @Override
    public void execute(Map<String, Object> map) throws Exception {
        CallResult callResult = this.getContactDAO().cctLogin((String)map.get("cctUname"), (String)map.get("cctPwd"), (String)map.get("cctDom"));
        CCTLoginCommand.setSsoToken(callResult.getMessage());
        Thread thread = new Thread(new SubscribeHandler());
        thread.start();
        this.buildUserContext();
        this.retrieveInProgressContactInfo();
        this.getRefClient().initUserContext(this.userContext);
        for (StateEventTO stateEventTO : this.currentStateEvents) {
            this.getRefClient().updateContactsInfo(stateEventTO);
        }
    }

    private UserContextDO buildUserContext() throws Exception {
        this.userContext.reset();
        this.terminals = this.getContactDAO().getUserTerminals(ssoToken);
        this.unmappedAddresses = this.getContactDAO().getUserAddresses(ssoToken);
        if (this.terminals != null) {
            for (TerminalTO terminalTO : this.terminals) {
                Object object = this.getContactDAO().getTerminalAddresses(terminalTO, ssoToken).iterator();
                while (object.hasNext()) {
                    AddressTO addressTO = object.next();
                    this.getCapabilitiesFacade().getCapabilities(addressTO, ssoToken);
                    terminalTO.addAddress(addressTO);
                    this.unmappedAddresses.remove(addressTO);
                }
                this.getCapabilitiesFacade().getCapabilities(terminalTO, ssoToken);
                Object object2 = this.getAgentTerminalServiceDAO().isLoggedIn(terminalTO, ssoToken);
                terminalTO.setAgentLoggedIn((Boolean)((CallResult)object2).getObject());
                object2 = this.getAgentTerminalServiceDAO().isReady(terminalTO, ssoToken);
                terminalTO.setTerminalReady((Boolean)((CallResult)object2).getObject());
                if (terminalTO.isAgentLoggedIn()) {
                    object2 = this.getAgentTerminalServiceDAO().getLoginId(terminalTO, ssoToken);
                    terminalTO.setLoginId(((CallResult)object2).getObject().toString());
                }
                if ((object = terminalTO.getTerminalCapabilities()) != null && ((TerminalCapabilitiesTO)object).isCanForward()) {
                    object2 = this.getTerminalServiceDAO().isForwarded(terminalTO, ssoToken);
                    terminalTO.setForwarding((Boolean)((CallResult)object2).getObject());
                }
                if (object != null && ((TerminalCapabilitiesTO)object).isCanDoNotDisturb()) {
                    object2 = this.getTerminalServiceDAO().getDoNotDisturb(terminalTO, ssoToken);
                    terminalTO.setDoNotDisturb((Boolean)((CallResult)object2).getObject());
                }
                object2 = this.getTerminalServiceDAO().getContactTypes(terminalTO, ssoToken);
                terminalTO.setContactTypes((List)((CallResult)object2).getObject());
            }
        }
        for (AddressTO addressTO : this.unmappedAddresses) {
            this.getCapabilitiesFacade().getCapabilities(addressTO, ssoToken);
            CallResult callResult = this.getRoutePointAddressServiceDAO().isControlled(addressTO, ssoToken);
            addressTO.setControlled((Boolean)callResult.getObject());
        }
        this.userContext.setTerminals(this.terminals);
        if (!this.unmappedAddresses.isEmpty()) {
            this.userContext.setUnmappedAddresses(this.unmappedAddresses);
        }
        return this.userContext;
    }

    private void retrieveInProgressContactInfo() throws Exception {
        this.currentStateEvents.clear();
        if (this.terminals != null) {
            for (TerminalTO terminalTO : this.terminals) {
                for (AddressTO addressTO : terminalTO.getAddresses()) {
                    List list = (List)this.getAddressServiceDAO().getConnections(addressTO, ssoToken).getObject();
                    for (ConnectionTO connectionTO : list) {
                        connectionTO.setAddressName(addressTO.getAddressName());
                        List list2 = (List)this.getConnectionServiceDAO().getTerminalConnections(connectionTO.getConnectionId(), ssoToken).getObject();
                        ContactTO contactTO = (ContactTO)this.getConnectionServiceDAO().getContact(connectionTO.getConnectionId(), ssoToken).getObject();
                        for (TerminalConnectionTO terminalConnectionTO : list2) {
                            TerminalTO terminalTO2 = (TerminalTO)this.getTerminalConnectionServiceDAO().getTerminal(terminalConnectionTO.getTerminalConnectionId(), ssoToken).getObject();
                            terminalConnectionTO.setTerminalName(terminalTO2.getTerminalName());
                            StateEventTO stateEventTO = new StateEventTO();
                            if (!terminalTO.getTerminalName().equals(terminalTO2.getTerminalName())) continue;
                            ContactTO contactTO2 = contactTO;
                            ConnectionTO connectionTO2 = connectionTO;
                            contactTO2.addConnection(connectionTO2);
                            List list3 = list2;
                            ConnectionTO connectionTO3 = contactTO2.getConnectionById(connectionTO2.getConnectionId());
                            if (connectionTO3 != null) {
                                connectionTO3.setTerminalConnections(list3);
                            }
                            this.userContext.addContact(contactTO2);
                            stateEventTO.setTerminal(terminalTO.getTerminalName());
                            stateEventTO.setAddress(addressTO.getAddressName());
                            stateEventTO.setConnection(connectionTO);
                            StateSummaryTO stateSummaryTO = (StateSummaryTO)this.getConnectionServiceDAO().getState(connectionTO.getConnectionId(), ssoToken).getObject();
                            stateEventTO.setRemoteState(stateSummaryTO.getCurrent());
                            stateEventTO.setContactId(contactTO.getContactId());
                            stateEventTO.setExternalContactId(contactTO.getExternalContactId());
                            stateEventTO.setTerminalConnection(terminalConnectionTO);
                            stateSummaryTO = (StateSummaryTO)this.getTerminalConnectionServiceDAO().getState(terminalConnectionTO.getTerminalConnectionId(), ssoToken).getObject();
                            stateEventTO.setLocalState(stateSummaryTO.getCurrent());
                            this.getCapabilitiesFacade().getCapabilities(connectionTO, ssoToken);
                            stateEventTO.getConnection().setCapabilities(connectionTO.getCapabilities());
                            this.getCapabilitiesFacade().getCapabilities(terminalConnectionTO, ssoToken);
                            stateEventTO.getTerminalConnection().setCapabilities(terminalConnectionTO.getCapabilities());
                            AddressTO addressTO2 = new AddressTO();
                            try {
                                addressTO2 = (AddressTO)this.getContactServiceDAO().getCallingAddress(contactTO.getContactId(), ssoToken).getObject();
                                stateEventTO.setCalling(addressTO2.getAddressName());
                            }
                            catch (Exception exception) {
                                stateEventTO.setCalling("Can't Get");
                            }
                            addressTO2 = new AddressTO();
                            try {
                                addressTO2 = (AddressTO)this.getContactServiceDAO().getCalledAddress(contactTO.getContactId(), ssoToken).getObject();
                                stateEventTO.setCalling(addressTO2.getAddressName());
                            }
                            catch (Exception exception) {
                                stateEventTO.setCalled("Can't Get");
                            }
                            this.currentStateEvents.add(stateEventTO);
                        }
                    }
                }
            }
        }
    }

    public IContactDAO getContactDAO() {
        return this.contactDAO;
    }

    public void setContactDAO(IContactDAO iContactDAO) {
        this.contactDAO = iContactDAO;
    }

    public INotificationDAO getNotificationDAO() {
        return this.notificationDAO;
    }

    public void setNotificationDAO(INotificationDAO iNotificationDAO) {
        this.notificationDAO = iNotificationDAO;
    }

    public ICapabilitiesFacade getCapabilitiesFacade() {
        return this.capabilitiesFacade;
    }

    public void setCapabilitiesFacade(ICapabilitiesFacade iCapabilitiesFacade) {
        this.capabilitiesFacade = iCapabilitiesFacade;
    }

    public IAddressServiceDAO getAddressServiceDAO() {
        return this.addressServiceDAO;
    }

    public void setAddressServiceDAO(IAddressServiceDAO iAddressServiceDAO) {
        this.addressServiceDAO = iAddressServiceDAO;
    }

    public IConnectionServiceDAO getConnectionServiceDAO() {
        return this.connectionServiceDAO;
    }

    public void setConnectionServiceDAO(IConnectionServiceDAO iConnectionServiceDAO) {
        this.connectionServiceDAO = iConnectionServiceDAO;
    }

    public IContactServiceDAO getContactServiceDAO() {
        return this.contactServiceDAO;
    }

    public void setContactServiceDAO(IContactServiceDAO iContactServiceDAO) {
        this.contactServiceDAO = iContactServiceDAO;
    }

    public ITerminalConnectionServiceDAO getTerminalConnectionServiceDAO() {
        return this.terminalConnectionServiceDAO;
    }

    public void setTerminalConnectionServiceDAO(ITerminalConnectionServiceDAO iTerminalConnectionServiceDAO) {
        this.terminalConnectionServiceDAO = iTerminalConnectionServiceDAO;
    }

    public IUserServiceDAO getUserServiceDAO() {
        return this.userServiceDAO;
    }

    public void setUserServiceDAO(IUserServiceDAO iUserServiceDAO) {
        this.userServiceDAO = iUserServiceDAO;
    }

    public IAgentTerminalServiceDAO getAgentTerminalServiceDAO() {
        return this.agentTerminalServiceDAO;
    }

    public void setAgentTerminalServiceDAO(IAgentTerminalServiceDAO iAgentTerminalServiceDAO) {
        this.agentTerminalServiceDAO = iAgentTerminalServiceDAO;
    }

    public ITerminalServiceDAO getTerminalServiceDAO() {
        return this.terminalServiceDAO;
    }

    public void setTerminalServiceDAO(ITerminalServiceDAO iTerminalServiceDAO) {
        this.terminalServiceDAO = iTerminalServiceDAO;
    }

    public IRoutePointAddressServiceDAO getRoutePointAddressServiceDAO() {
        return this.routePointAddressServiceDAO;
    }

    public void setRoutePointAddressServiceDAO(IRoutePointAddressServiceDAO iRoutePointAddressServiceDAO) {
        this.routePointAddressServiceDAO = iRoutePointAddressServiceDAO;
    }

    private class SubscribeHandler
    implements Runnable {
        private SubscribeHandler() {
        }

        @Override
        public void run() {
            try {
                CCTLoginCommand.this.getNotificationDAO().subscribe(null, null, Command.ssoToken);
                CCTLoginCommand.this.getUserServiceDAO().startHASwitchEventListener(Command.ssoToken);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

