/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.command;

import com.nortel.rc.command.Command;
import com.nortel.rc.dao.IAgentServiceDAO;
import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetAgentStateCommand
extends Command {
    private IContactDAO contactDAO;
    private IAgentServiceDAO agentServiceDAO;
    ICapabilitiesFacade capabilitiesFacade;

    @Override
    public void execute(Map<String, Object> map) throws Exception {
        List<AgentTO> list;
        boolean bl = false;
        if (map != null && map.get("agent") != null) {
            list = new ArrayList<AgentTO>();
            list.add((AgentTO)map.get("agent"));
        } else {
            bl = true;
            list = this.getContactDAO().getAgents(ssoToken);
        }
        HashMap<String, AgentTO> hashMap = new HashMap<String, AgentTO>();
        AgentTO agentTO = null;
        for (int i = 0; i < list.size(); ++i) {
            CallResult callResult;
            agentTO = list.get(i);
            try {
                callResult = this.getAgentServiceDAO().isLoggedIn(agentTO, ssoToken);
                agentTO.setLoggedIn((Boolean)callResult.getObject());
            }
            catch (DAOException dAOException) {
                agentTO.setLoggedIn(false);
            }
            if (agentTO.isLoggedIn()) {
                callResult = this.getAgentServiceDAO().getReadyState(agentTO, ssoToken);
                agentTO.setReady((Boolean)callResult.getObject());
                if (!agentTO.isReady()) {
                    callResult = this.getAgentServiceDAO().getNotReadyReasonCode(agentTO, ssoToken);
                    agentTO.setNotReadyReasonCode((String)callResult.getObject());
                }
            }
            try {
                callResult = this.getAgentServiceDAO().getStaticVoiceTerminal(agentTO, ssoToken);
                agentTO.setStaticVoiceTerminal((TerminalTO)callResult.getObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                callResult = this.getAgentServiceDAO().getSupervisor(agentTO, ssoToken);
                agentTO.setSupervisor((AgentTO)callResult.getObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getCapabilitiesFacade().getCapabilities(agentTO, ssoToken);
            try {
                agentTO.setContactTypes((List)this.getAgentServiceDAO().getContactTypes(agentTO, ssoToken).getObject());
            }
            catch (DAOException dAOException) {
                // empty catch block
            }
            hashMap.put(agentTO.getAgentLoginId(), agentTO);
        }
        if (bl) {
            this.getRefClient().updateAgentContext(hashMap);
        } else if (agentTO != null) {
            this.getRefClient().updateSingleAgentContext(agentTO);
        }
    }

    public IAgentServiceDAO getAgentServiceDAO() {
        return this.agentServiceDAO;
    }

    public void setAgentServiceDAO(IAgentServiceDAO iAgentServiceDAO) {
        this.agentServiceDAO = iAgentServiceDAO;
    }

    public IContactDAO getContactDAO() {
        return this.contactDAO;
    }

    public void setContactDAO(IContactDAO iContactDAO) {
        this.contactDAO = iContactDAO;
    }

    public ICapabilitiesFacade getCapabilitiesFacade() {
        return this.capabilitiesFacade;
    }

    public void setCapabilitiesFacade(ICapabilitiesFacade iCapabilitiesFacade) {
        this.capabilitiesFacade = iCapabilitiesFacade;
    }
}

