/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.dao.IAgentTerminalServiceDAO;
import com.nortel.rc.dao.ServiceDAO;
import com.nortel.rc.dto.AgentTerminalCapabilitiesTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.agentterminalservice.AgentTerminalService;
import com.nortel.soa.oi.cct.agentterminalservice.SOAOICCTAgentTerminalService;
import com.nortel.soa.oi.cct.faults.GetCapabilitiesException;
import com.nortel.soa.oi.cct.types.AgentTerminalCapabilities;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalType;
import com.nortel.soa.oi.cct.types.agentterminalservice.BooleanTerminalRequest;
import com.nortel.soa.oi.cct.types.agentterminalservice.GetActivityCodeResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.GetAgentTerminalCapabilitiesResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.GetDoNotDisturbResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.GetLoginIdResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.IsForwardedResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.IsReadyResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.StringTerminalRequest;
import com.nortel.soa.oi.cct.types.agentterminalservice.TerminalRequest;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AgentTerminalServiceDAO
extends ServiceDAO
implements IAgentTerminalServiceDAO {
    private static Logger logger = Logger.getLogger((String)"rc.dao.AgentTerminalServiceDAO");
    private String endPoint = null;

    @Override
    public CallResult getCapabilities(TerminalTO terminalTO, String string) throws DAOException {
        Object object;
        String string2 = "getCapabilities():";
        TerminalRequest terminalRequest = new TerminalRequest();
        AgentTerminalCapabilities agentTerminalCapabilities = null;
        SsoToken ssoToken = new SsoToken();
        Terminal terminal = new Terminal();
        terminal.setTerminalName(terminalTO.getTerminalName());
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        try {
            object = this.getPort().getCapabilities(terminalRequest);
            if (object == null) {
                throw new GetCapabilitiesException("NULL response received");
            }
            agentTerminalCapabilities = ((GetAgentTerminalCapabilitiesResponse)object).getTerminalCapabilities();
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        object = new AgentTerminalCapabilitiesTO();
        ((AgentTerminalCapabilitiesTO)object).setCanGetActivityCode(agentTerminalCapabilities.isCanGetActivityCode());
        ((AgentTerminalCapabilitiesTO)object).setCanGetNotReadyReason(agentTerminalCapabilities.isCanGetNotReadyReason());
        ((AgentTerminalCapabilitiesTO)object).setCanGetReadyStatus(agentTerminalCapabilities.isCanGetReadyStatus());
        ((AgentTerminalCapabilitiesTO)object).setCanLogin(agentTerminalCapabilities.isCanLogin());
        ((AgentTerminalCapabilitiesTO)object).setCanLogout(agentTerminalCapabilities.isCanLogout());
        ((AgentTerminalCapabilitiesTO)object).setCanSetActivityCode(agentTerminalCapabilities.isCanSetActivityCode());
        ((AgentTerminalCapabilitiesTO)object).setCanSetNotReadyReason(agentTerminalCapabilities.isCanSetNotReadyReason());
        ((AgentTerminalCapabilitiesTO)object).setCanSetReadyStatus(agentTerminalCapabilities.isCanSetReadyStatus());
        CallResult callResult = new CallResult();
        callResult.setObject(object);
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallResult isLoggedIn(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "isLoggedIn():";
        TerminalRequest terminalRequest = new TerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        GetLoginIdResponse getLoginIdResponse = null;
        CallResult callResult = new CallResult();
        try {
            getLoginIdResponse = this.getPort().getLoginId(terminalRequest);
        }
        catch (Exception exception) {
            callResult.setObject(false);
            this.logExecption(logger, string2, exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        callResult.setObject(getLoginIdResponse != null && getLoginIdResponse.getLoginId() != null);
        return callResult;
    }

    @Override
    public CallResult isForwarded(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "isForwarded():";
        TerminalRequest terminalRequest = new TerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        IsForwardedResponse isForwardedResponse = null;
        try {
            isForwardedResponse = this.getPort().isForwarded(terminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setObject(isForwardedResponse != null ? isForwardedResponse.isIsForwarded() : false);
        return callResult;
    }

    @Override
    public CallResult getDoNotDisturb(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "getDoNotDisturb():";
        TerminalRequest terminalRequest = new TerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        GetDoNotDisturbResponse getDoNotDisturbResponse = null;
        try {
            getDoNotDisturbResponse = this.getPort().getDoNotDisturb(terminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setObject(getDoNotDisturbResponse != null ? getDoNotDisturbResponse.isDoNotDisturb() : false);
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallResult isReady(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "isReady():";
        TerminalRequest terminalRequest = new TerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        IsReadyResponse isReadyResponse = null;
        CallResult callResult = new CallResult();
        try {
            isReadyResponse = this.getPort().isReady(terminalRequest);
        }
        catch (Exception exception) {
            callResult.setObject(false);
            this.logExecption(logger, string2, exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        callResult.setObject(isReadyResponse != null ? isReadyResponse.isIsReady() : false);
        return callResult;
    }

    @Override
    public CallResult getActivityCode(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "getActivityCode():";
        TerminalRequest terminalRequest = new TerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        GetActivityCodeResponse getActivityCodeResponse = null;
        try {
            getActivityCodeResponse = this.getPort().getActivityCode(terminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        CallResult callResult = new CallResult();
        callResult.setMessage(getActivityCodeResponse != null ? getActivityCodeResponse.getActivityCode() : null);
        return callResult;
    }

    @Override
    public CallResult setIsReady(TerminalTO terminalTO, boolean bl, String string) throws DAOException {
        String string2 = "setIsReady():";
        BooleanTerminalRequest booleanTerminalRequest = new BooleanTerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        booleanTerminalRequest.setTerminal(terminal);
        booleanTerminalRequest.setSsoToken(ssoToken);
        booleanTerminalRequest.setValue(bl);
        try {
            this.getPort().setIsReady(booleanTerminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        return null;
    }

    @Override
    public CallResult setNotReadyReasonCode(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "setNotReadyReasonCode():";
        StringTerminalRequest stringTerminalRequest = new StringTerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        stringTerminalRequest.setTerminal(terminal);
        stringTerminalRequest.setSsoToken(ssoToken);
        stringTerminalRequest.setValue(terminalTO.getTerminalNotReadyReason());
        try {
            this.getPort().setNotReadyReasonCode(stringTerminalRequest);
        }
        catch (Exception exception) {
            this.logExecption(logger, string2, exception);
            throw new DAOException(exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallResult getLoginId(TerminalTO terminalTO, String string) throws DAOException {
        String string2 = "getLoginId():";
        TerminalRequest terminalRequest = new TerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        terminal.setTerminalType(TerminalType.valueOf(terminalTO.getTerminalType()));
        terminal.setTerminalName(terminalTO.getTerminalName());
        ssoToken.setToken(string);
        terminalRequest.setTerminal(terminal);
        terminalRequest.setSsoToken(ssoToken);
        GetLoginIdResponse getLoginIdResponse = null;
        CallResult callResult = new CallResult();
        try {
            getLoginIdResponse = this.getPort().getLoginId(terminalRequest);
        }
        catch (Exception exception) {
            callResult.setObject(false);
            this.logExecption(logger, string2, exception);
        }
        finally {
            logger.log((Priority)Level.INFO, (Object)(string2 + " sso[" + string + "] endpoint : " + this.endPoint));
        }
        callResult.setObject(getLoginIdResponse != null && getLoginIdResponse.getLoginId() != null ? getLoginIdResponse.getLoginId() : "");
        return callResult;
    }

    public AgentTerminalService getPort() throws DAOException {
        Object object;
        Object object2;
        if (this.endPoint == null) {
            object2 = new SOAOICCTAgentTerminalService(this.getWsdlUrl(), this.getServiceQName());
            object = object2.getWSDLDocumentLocation();
            this.endPoint = ((URL)object).getProtocol() + "://" + ((URL)object).getAuthority() + ((URL)object).getPath();
        }
        object2 = new JaxWsProxyFactoryBean();
        object2.setServiceClass(AgentTerminalService.class);
        object = (AgentTerminalService)object2.create();
        ((BindingProvider)object).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint);
        return object;
    }
}

