/*
 * Decompiled with CFR 0.152.
 */
package com.nortel.rc.dao;

import com.nortel.rc.exception.DAOException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.springframework.core.io.ClassPathResource;

public class ServiceDAO {
    private QName serviceQName;
    private String endpointFilename;
    private String serverDetails;
    private String serviceUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDAO() {
        ClassPathResource classPathResource = new ClassPathResource("endpoint.txt");
        BufferedReader bufferedReader = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(classPathResource.getFile()));
            bufferedReader = new BufferedReader(inputStreamReader);
            this.serverDetails = String.valueOf(bufferedReader.readLine()).trim();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public URL getWsdlUrl() throws DAOException {
        URL uRL = null;
        try {
            uRL = new URL(this.getServerDetails() + this.getServiceUrl());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        System.out.println("Getting wsdlUrl for service call: " + this.getServerDetails() + this.getServiceUrl());
        return uRL;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public void setServiceQName(QName qName) {
        this.serviceQName = qName;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String string) {
        this.serviceUrl = string;
    }

    public String getServerDetails() {
        return this.serverDetails;
    }

    public void setServerDetails(String string) {
        this.serverDetails = string;
    }

    public String getEndpointFilename() {
        return this.endpointFilename;
    }

    public void setEndpointFilename(String string) {
        this.endpointFilename = string;
    }

    public void logExecption(Logger logger, String string, Exception exception) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(exception.getCause());
        stringBuilder.append("\n");
        stringBuilder.append(exception.getMessage());
        stringBuilder.append("\n");
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            stringBuilder.append(stackTraceElement.toString());
            stringBuilder.append("\n");
        }
        logger.log((Priority)Level.ERROR, (Object)stringBuilder.toString());
    }
}

