package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dto.AttachedDataTO;

public class GetContactDataCommand extends Command 
{
	private IContactDAO contactDAO;
	private AttachedDataTO data;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		String contactId = (String)params.get("contactId");
		data = (AttachedDataTO)getContactDAO().getContactData(contactId, ssoToken).getObject();
		getRefClient().updateAttachedData(contactId, data);
	}	
	
	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}
}
