//////////////////////////////////////////////////////////////////////////////
// SwitchOverHandlerCommand.java
//
// Avaya Inc. - Proprietary (Restricted)
// Solely for authorized persons having a need to know
// pursuant to Company instructions.
//
// Copyright  2008-2013 Avaya Inc. All rights reserved.
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
// The copyright notice above does not evidence any actual
// or intended publication of such source code.
//////////////////////////////////////////////////////////////////////////////
package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IUserServiceDAO;

/**
 * @author jdwyer
 *
 */
public class SwitchOverHandlerCommand extends Command 
{
	private IUserServiceDAO userServiceDAO;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		getUserServiceDAO().sessionHeartbeatAndHACheck(ssoToken);
	}
	
	/**
	 * @return the userServiceDAO
	 */
	public IUserServiceDAO getUserServiceDAO() {
		return userServiceDAO;
	}

	/**
	 * @param _userServiceDAO the userServiceDAO to set
	 */
	public void setUserServiceDAO(IUserServiceDAO userServiceDAO) {
		this.userServiceDAO = userServiceDAO;
	}
}
