package com.nortel.rc.dao;

import java.net.URL;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.routepointaddressservice.RoutePointAddressService;
import com.nortel.soa.oi.cct.routepointaddressservice.SOAOICCTRoutePointAddressService;
import com.nortel.soa.oi.cct.sessionservice.SessionService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.routepointaddressservice.BooleanResponse;
import com.nortel.soa.oi.cct.types.routepointaddressservice.RoutePointAddressRequest;

public class RoutePointAddressServiceDAO extends ServiceDAO implements IRoutePointAddressServiceDAO
{	
	private static Logger logger = Logger.getLogger("rc.dao.RoutePointAddressServiceDAO");
	private String endPoint = null;
    
	public CallResult control(AddressTO addr, String sso) throws DAOException
    {        
		String methodName = "control():"; 
		RoutePointAddressRequest routePointAddressRequest = new RoutePointAddressRequest();
        SsoToken ssoToken = new SsoToken();
        
        if(addr != null)
        {
        	Address address = new Address();
        	address.setAddressName(addr.getAddressName());
        	address.setAddressType(AddressType.valueOf(addr.getAddressType()));
        	routePointAddressRequest.setRoutePointAddress(address);
        }				
		ssoToken.setToken(sso);
		
		routePointAddressRequest.setSsoToken(ssoToken);
	    
	    try {        	
	    	getPort().control(routePointAddressRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }

        return null;
    }
	
	public CallResult releaseControl(AddressTO addr, String sso) throws DAOException
    {        
		String methodName = "releaseControl():"; 
		RoutePointAddressRequest routePointAddressRequest = new RoutePointAddressRequest();
        SsoToken ssoToken = new SsoToken();
        
        if(addr != null)
        {
        	Address address = new Address();
        	address.setAddressName(addr.getAddressName());
        	address.setAddressType(AddressType.valueOf(addr.getAddressType()));
        	routePointAddressRequest.setRoutePointAddress(address);
        }				
		ssoToken.setToken(sso);
		
		routePointAddressRequest.setSsoToken(ssoToken);
	    
	    try {        	
	    	getPort().releaseControl(routePointAddressRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }

        return null;
    }
	
	public CallResult isControlled(AddressTO addr, String sso) throws DAOException
    {        
		String methodName = "isControlled():"; 
		RoutePointAddressRequest routePointAddressRequest = new RoutePointAddressRequest();
        SsoToken ssoToken = new SsoToken();
        
        if(addr != null)
        {
        	Address address = new Address();
        	address.setAddressName(addr.getAddressName());
        	address.setAddressType(AddressType.valueOf(addr.getAddressType()));
        	routePointAddressRequest.setRoutePointAddress(address);
        }				
		ssoToken.setToken(sso);
		
		routePointAddressRequest.setSsoToken(ssoToken);        
		
        BooleanResponse response;
	    
	    try {        	
	    	response = getPort().isControlled(routePointAddressRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(response != null ? response.isResponse() : false);
        return result;
    }
	
	/**
	 * @return {@link SessionService}
	 * Retrieves interface to be used by service consumers
	 */
	public RoutePointAddressService getPort() throws DAOException{
		if(endPoint == null)
		{			
			SOAOICCTRoutePointAddressService ss = new SOAOICCTRoutePointAddressService(getWsdlUrl(), getServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}

		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setServiceClass(RoutePointAddressService.class);
		RoutePointAddressService service = (RoutePointAddressService) factory.create();
		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);

		return service;
	}
}
