//////////////////////////////////////////////////////////////////////////////
// UserServiceDAO.java
//
// Avaya Inc. - Proprietary (Restricted)
// Solely for authorized persons having a need to know
// pursuant to Company instructions.
//
// Copyright  2008-2013 Avaya Inc. All rights reserved.
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
// The copyright notice above does not evidence any actual
// or intended publication of such source code.
//////////////////////////////////////////////////////////////////////////////
package com.nortel.rc.dao;

import java.net.URL;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.event.HASwitchOverHandler;
import com.nortel.rc.exception.DAOException;
import com.nortel.rc.gui.SOARefClient;
import com.nortel.soa.oi.cct.sessionservice.SessionService;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.userservice.SessionHeartbeatAndHACheckRequest;
import com.nortel.soa.oi.cct.types.userservice.SessionHeartbeatAndHACheckResponse;
import com.nortel.soa.oi.cct.types.userservice.StartHASwitchEventListenerRequest;
import com.nortel.soa.oi.cct.types.userservice.StartHASwitchEventListenerResponse;
import com.nortel.soa.oi.cct.userservice.SOAOICCTUserService;
import com.nortel.soa.oi.cct.userservice.UserService;

/**
 * @author jdwyer
 *
 */
public class UserServiceDAO extends ServiceDAO implements IUserServiceDAO
{	
	private static Logger logger = Logger.getLogger("rc.dao.UserServiceDAO");
	
	String endPoint = null;
	
    /* (non-Javadoc)
	 * @see com.nortel.rc.dao.IUserServiceDAO#sessionHeartbeatAndHACheck(java.lang.String)
	 */
	@Override
	public void sessionHeartbeatAndHACheck(String sso)
			throws DAOException {
		String methodName = "sessionHeartbeatAndHACheck():";
		SessionHeartbeatAndHACheckRequest request = new SessionHeartbeatAndHACheckRequest();
    	SsoToken ssoToken = new SsoToken();
    	ssoToken.setToken(sso);
		request.setSsoToken(ssoToken);
		try
		{
			
			SessionHeartbeatAndHACheckResponse response = getPort().sessionHeartbeatAndHACheck(request);
			
			if(response != null) {
				String message = "Response session update["+ response.isSessionUpdated()+"] switchover["+response.isHASwitchOver()+"]";
				logger.log(Level.INFO, message);
				SOARefClient.reportEvent(methodName, message);
			} else
				throw new Exception("StartHASwitchEventListenerResponse cannot be NULL");
			
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
        	SOARefClient.reportError(methodName, e.getMessage());
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
        
	}
	
	/* (non-Javadoc)
	 * @see com.nortel.rc.dao.IUserServiceDAO#startHASwitchEventListener(java.lang.String)
	 */
	@Override
	public void startHASwitchEventListener(String sso) throws DAOException {
		String methodName = "startHASwitchEventListener():";
		StartHASwitchEventListenerRequest request = new StartHASwitchEventListenerRequest();
    	SsoToken ssoToken = new SsoToken();
    	ssoToken.setToken(sso);
		request.setSsoToken(ssoToken);
		request.setConsumerEndpoint(HASwitchOverHandler.consumerAddress);
		try
		{
			
			StartHASwitchEventListenerResponse response = getPort().startHASwitchEventListener(request);
			
			if(response != null) {
				String message = "Response success["+ response.isSuccess();
				logger.log(Level.INFO, message);
				SOARefClient.reportEvent(methodName, message);
			} else
				throw new Exception("StartHASwitchEventListenerResponse cannot be NULL");
			
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
        	SOARefClient.reportError(methodName, e.getMessage());
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ HASwitchOverHandler.consumerAddress);
	    }
		
	}

    /**
	 * @return {@link SessionService}
	 * Retrieves interface to be used by service consumers
	 */
	public UserService getPort() throws DAOException
	{		
		if(endPoint == null){
			SOAOICCTUserService ss = new SOAOICCTUserService(getWsdlUrl(), getServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}
		
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setServiceClass(UserService.class);
		UserService service = (UserService) factory.create();
		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);
		
		return service;
	}

	
	
}
