package com.nortel.rc.gui;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import com.nortel.rc.dto.UserContextDO;

@SuppressWarnings("serial")
public class DeviceTreeCellRenderer extends DefaultTreeCellRenderer {
	
	private UserContextDO userContext = null;

	public DeviceTreeCellRenderer(UserContextDO userContext)
	{
		super();
		this.userContext = userContext;
	}
	
	public Component getTreeCellRendererComponent(JTree tree,
													Object value,
													boolean sel,
													boolean expanded,
													boolean leaf,
													int row,
													boolean hasFocus)
	{
		Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, 
		leaf, row, hasFocus);
		if ((userContext.getTerminal(value.toString()) != null
				&& userContext.getTerminal(value.toString()).isOutOfService())
				|| (userContext.getAddress(value.toString()) != null
						&& userContext.getAddress(value.toString()).isOutOfService()))
		{
			comp.setForeground(Color.RED);
		}
		else
		{
			comp.setForeground(Color.BLACK);
		}
		this.setBackgroundSelectionColor(Color.LIGHT_GRAY);
		this.setBackgroundNonSelectionColor(Color.WHITE);
		this.setBorderSelectionColor(Color.WHITE);

		return comp;
	} 
}
