package sample.soa.cct;

import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;

import org.oasis_open.docs.wsrf._2004._06.wsrf_ws_resourceproperties_1_2_draft_01.QueryExpressionType;
import org.xmlsoap.schemas.ws._2003._03.addressing.AttributedURI;
import org.xmlsoap.schemas.ws._2003._03.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws._2003._03.addressing.ServiceNameType;

import com.nortel.soa.oi.cct.basenotification.NotificationTopicType;
import com.nortel.soa.oi.cct.basenotification.TerminalConnectionStateListenerType;
import com.nortel.soa.oi.cct.basenotification.TopicExpressionType;
import com.nortel.soa.oi.cct.notification.SubscriptionPolicyType;
import com.nortel.soa.oi.cct.notificationproducer.NotificationProducer;
import com.nortel.soa.oi.cct.notificationproducer.SOAOICCTNotificationProducer;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalConnectionState;

import sample.soa.cct.nc.NotificationConsumerImpl;

public class SubscribeUtil {

	
	private static String ipAddress = "192.168.1.35"; 
	private static String port = "9090";
	//private static String ipAddress = "ENTER YOUR LOCAL IP_ADDRESS"; 
	//private static String port = "ENTER YOU LOCAL CONSUMING PORT";
	private static NotificationConsumerImpl notificationHandler;
	private static String notificationConsumerUri  = "http://" + ipAddress + ":" + port + "/SOAOICCT/services/NotificationConsumer";;
	private static NotificationProducer  notificationProducerService;
	private static String localIpAddress;
	
	
	/* 
	 * Gets a connection to the NotificationProducer service that allows the 
	 * user to register for notifications
	 */
	public static NotificationProducer getNotificationProducerService(String serverDetails, String serverPort) {
        
        try {
        	String nplocation = "http://"+ serverDetails +  ":" + serverPort + "/SOAOICCT/services/NotificationProducer?wsdl";
        	URL url = new URL(nplocation);
        	notificationProducerService = new SOAOICCTNotificationProducer(url).getNotificationProducer();        
        } catch (Exception e) {
        	e.printStackTrace();
        }
        return notificationProducerService;
    }
	
	private static String getIpAddress() {
	        
	        if (localIpAddress == null) {
	            try {
	                InetAddress addr = InetAddress.getLocalHost();
	                localIpAddress = addr.getHostAddress();
	                System.out.println("IP Address : " + localIpAddress.toString());
	            }
	            catch (Exception e) {
	                e.printStackTrace();
	            }
	        }
	
	        return localIpAddress;
	    }
    
    
	 
	
	public static void publishNotificationConsumer() {
		String notificationConsumerUri  = "http://" + getIpAddress() + ":" + port + "/SOAOICCT/services/NotificationConsumer";;
		notificationHandler = new NotificationConsumerImpl();
	    Endpoint.publish(notificationConsumerUri, notificationHandler);
	}
	 
	 
	 public static EndpointReferenceType subscribe(SsoToken ssoToken, String serverDetails, String serverPort) throws Exception {
	    	
		 	getNotificationProducerService(serverDetails, serverPort);
	    	
	    	//Setup the endpoint reference type object 
	    	//This object details the endpoint where notifications will be sent to
	        EndpointReferenceType consumerReference = new EndpointReferenceType();
	        AttributedURI value = new AttributedURI();
	        value.setValue(notificationConsumerUri);
	       
	        QName name = new QName("http://www.nortel.com/soa/oi/cct/NotificationConsumer", "SOAOICCT_NotificationConsumer");   
	        consumerReference.setAddress(value);
	        consumerReference.setServiceName(new ServiceNameType());
	        consumerReference.getServiceName().setPortName("NotificationConsumer");
	        consumerReference.getServiceName().setValue(name);
	        
	    	
	    	 Boolean useNotify = true;
	         QueryExpressionType precondition = null;
	         QueryExpressionType selector = null;
	         XMLGregorianCalendar initialTerminationTime = null;

	         SubscriptionPolicyType subscriptionPolicy = new SubscriptionPolicyType();
	         subscriptionPolicy.setSessionTerminationImminentNotificationsEnabled(true);
	         subscriptionPolicy.setSessionTerminationNotificationsEnabled(true);
	         subscriptionPolicy.setSubscriptionTerminationImminentNotificationsEnabled(true);
	         subscriptionPolicy.setSubscriptionTerminationNotificationsEnabled(true);
	       
	         
	         //Detail the types of notifications that you are going to subscribe for
	         TopicExpressionType topicExp = new TopicExpressionType();
	         topicExp.setDialect("Simple");
	         NotificationTopicType notificationTopic = new NotificationTopicType();
	         
	         
	         TerminalConnectionStateListenerType terminalConnectionStateListener = new TerminalConnectionStateListenerType();
	         List<TerminalConnectionState> terminalConnectionStateListenerEvents = new ArrayList<TerminalConnectionState>();
	         terminalConnectionStateListener.getTerminalConnectionStateEvent().addAll(terminalConnectionStateListenerEvents);
	         List<Terminal> terminalConnectionStateListenerEntities = new ArrayList<Terminal>();
	         terminalConnectionStateListener.getTerminalEntity().addAll(terminalConnectionStateListenerEntities);
	         notificationTopic.setTerminalConnectionStateListener(terminalConnectionStateListener);
	         
	         QName _TopicExpressionTypeNotificationTopic_QNAME = new QName("http://www.nortel.com/soa/oi/cct/BaseNotification", "NotificationTopic");
	         JAXBElement<NotificationTopicType> notificationTopicType = new JAXBElement<NotificationTopicType>(_TopicExpressionTypeNotificationTopic_QNAME, NotificationTopicType.class, TopicExpressionType.class, notificationTopic);
	         
	         topicExp.getContent().add(notificationTopicType);

	         
	         //Call the subscribe service
	         try {
	             
	             
	        	 EndpointReferenceType subscriptionEndpoint = notificationProducerService.subscribe(
	                 consumerReference, 
	                 topicExp, 
	                 useNotify, 
	                 precondition, 
	                 selector, 
	                 subscriptionPolicy, 
	                 initialTerminationTime, 
	                 ssoToken);
	        	 return subscriptionEndpoint;
	         }
	         catch (Exception e ) {
	        	 e.printStackTrace();
	        	 throw e;
	         }
	         
	     }
	 
	
}
