package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.TerminalTO;

public class AgentLoginCommand extends Command 
{
	private IContactDAO contactDAO;
	
	public void execute(Map<String, Object> params) throws Exception
	{		
		TerminalTO terminal = (TerminalTO)params.get("terminal");
		
		AgentTO agent = (AgentTO)params.get("agent");
					
		getContactDAO().loginAgentToState(terminal, agent, Integer.parseInt((String)params.get("agentState")), ssoToken);
	}

	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}
}
