package com.nortel.rc.command;

import java.util.Map;


import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dto.AttachedDataTO;
import org.apache.log4j.Category;

public class GetAttachedDataCommand extends Command 
{
	private IContactServiceDAO contactServiceDAO;
	private AttachedDataTO data;
	private static final Category log = Category.getInstance(GetAttachedDataCommand.class.getName());
   
	public void execute(Map<String, Object> params) throws Exception
	{
		String contactId = (String)params.get("contactId");
		data = (AttachedDataTO)getContactServiceDAO().getAttachedData(contactId, ssoToken).getObject();    
      log.info("GetAttachedDataCommand: " + data);
		getRefClient().updateAttachedData(contactId, data);
	}	
	
	/**
	 * @return the contactServiceDAO
	 */
	public IContactServiceDAO getContactServiceDAO() {
		return contactServiceDAO;
	}

	/**
	 * @param contactServiceDAO the contactServiceDAO to set
	 */
	public void setContactServiceDAO(IContactServiceDAO contactServiceDAO) {
		this.contactServiceDAO = contactServiceDAO;
	}
    
}
