package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IRoutePointConnectionServiceDAO;
import com.nortel.rc.dto.ConnectionTO;

public class GetRoutePointConnectionCapabilitiesCommand extends Command 
{
	private IRoutePointConnectionServiceDAO routePointConnectionServiceDAO;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		ConnectionTO connection = (ConnectionTO)params.get("connection");
		
		getRoutePointConnectionServiceDAO().getCapabilities(connection, ssoToken).getObject();		
	}

	/**
	 * @return the routePointConnectionServiceDAO
	 */
	public IRoutePointConnectionServiceDAO getRoutePointConnectionServiceDAO() {
		return routePointConnectionServiceDAO;
	}

	/**
	 * @param routePointConnectionServiceDAO the routePointConnectionServiceDAO to set
	 */
	public void setRoutePointConnectionServiceDAO(
			IRoutePointConnectionServiceDAO routePointConnectionServiceDAO) {
		this.routePointConnectionServiceDAO = routePointConnectionServiceDAO;
	}
	
	
}
