package com.nortel.rc.command;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;

import org.springframework.core.io.ClassPathResource;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class GetServerDetailsCommand extends Command 
{
	private String endpointFilename;
	private static final Logger LOG = Logger.getLogger(GetServerDetailsCommand.class);
	
	public void execute(Map<String, Object> params) throws Exception
	{
	
		//Read serverDetails from endpoint file
		ClassPathResource res = new ClassPathResource(getEndpointFilename());		
		System.out.println("Using file at: "+res.getURL().toURI());
		if (LOG.isInfoEnabled()){
			LOG.log(Level.INFO, "Using file at: "+res.getURL().toURI());
		}
		
		BufferedReader reader =  null;
		try {
			reader = new BufferedReader(new InputStreamReader(new FileInputStream(res.getFile())));
			StringTokenizer tokenStr = new StringTokenizer(String.valueOf(reader.readLine()).trim(), ":");
			String protocol = tokenStr.nextToken();
			String server = tokenStr.nextToken().substring(2);
			String port = tokenStr.nextToken();
			if (LOG.isInfoEnabled()){
				LOG.log(Level.INFO, "execute :"+" protocol ["+protocol+"] Server ["+server+"] Port ["+port+"]");
			}
			getRefClient().updateServerSettings(server, port, protocol.equalsIgnoreCase("https"));
			
		} catch (FileNotFoundException e) {
			LOG.log(Level.WARN, "execute : Failed to find endpoint file);");
			throw new Exception (e);
			
		} catch (IOException e) {
			LOG.log(Level.WARN, "execute : Failed to read endpoint file);");
			throw new Exception (e);
			
		} finally{
			try{
				if (reader != null) 
					reader.close();
			}catch (IOException e) {
				LOG.log(Level.WARN, "execute : Failed to close endpoint file reader!);");
			}
		}
	}

	/**
	 * @return the endpointFilename
	 */
	public String getEndpointFilename() {
		return endpointFilename;
	}

	/**
	 * @param endpointFilename the endpointFilename to set
	 */
	public void setEndpointFilename(String endpointFilename) {
		this.endpointFilename = endpointFilename;
	}
}
