package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IAgentTerminalServiceDAO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.TerminalTO;

public class GetTerminalLoginIdCommand extends Command 
{
	private IAgentTerminalServiceDAO agentTerminalServiceDAO;
		
	public void execute(Map<String, Object> params) throws Exception
	{
		TerminalTO terminal = (TerminalTO)params.get("terminal");
		if (terminal != null){
			CallResult cr;
		
			cr = getAgentTerminalServiceDAO().getLoginId(terminal, ssoToken);
			terminal.setLoginId(cr.getObject().toString());
		}	
	}

	/**
	 * @return the agentTerminalServiceDAO
	 */
	public IAgentTerminalServiceDAO getAgentTerminalServiceDAO() {
		return agentTerminalServiceDAO;
	}

	/**
	 * @param agentTerminalServiceDAO the agentTerminalServiceDAO to set
	 */
	public void setAgentTerminalServiceDAO(
			IAgentTerminalServiceDAO agentTerminalServiceDAO) {
		this.agentTerminalServiceDAO = agentTerminalServiceDAO;
	}
	
}
