package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dto.AttachedDataTO;

public class SetAttachedDataCommand extends Command 
{
	private IContactServiceDAO contactServiceDAO;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		AttachedDataTO attachedData = (AttachedDataTO)params.get("attachedData");
		getContactServiceDAO().setAttachedData((String)params.get("contactId"), attachedData, ssoToken);	
	}

	/**
	 * @return the contactServiceDAO
	 */
	public IContactServiceDAO getContactServiceDAO() {
		return contactServiceDAO;
	}

	/**
	 * @param contactServiceDAO the contactServiceDAO to set
	 */
	public void setContactServiceDAO(IContactServiceDAO contactServiceDAO) {
		this.contactServiceDAO = contactServiceDAO;
	}
}