package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dto.AttachedDataTO;

public class SetContactDataCommand extends Command 
{
	private IContactDAO contactDAO;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		AttachedDataTO attachedData = (AttachedDataTO)params.get("attachedData");
		getContactDAO().setContactData((String)params.get("contactId"), attachedData, ssoToken);	
	}

	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}
}