package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.ITerminalServiceDAO;
import com.nortel.rc.dto.TerminalTO;

public class SetDoNotDisturbTerminalCommand extends Command 
{
	private ITerminalServiceDAO terminalServiceDAO;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		TerminalTO terminal = (TerminalTO)params.get("terminal");
		terminal.setDoNotDisturb(!terminal.isDoNotDisturb());
		
		getTerminalServiceDAO().setDoNotDisturb(terminal, ssoToken);
	}

	/**
	 * @return the terminalServiceDAO
	 */
	public ITerminalServiceDAO getTerminalServiceDAO() {
		return terminalServiceDAO;
	}

	/**
	 * @param terminalServiceDAO the terminalServiceDAO to set
	 */
	public void setTerminalServiceDAO(ITerminalServiceDAO terminalServiceDAO) {
		this.terminalServiceDAO = terminalServiceDAO;
	}	
}
