package com.nortel.rc.dao;

import com.nortel.rc.dto.CallResult;
import com.nortel.rc.exception.DAOException;

public interface IConnectionServiceDAO extends IServiceDAO
{
	public CallResult getCapabilities(String connectionId, String sso) 
			throws DAOException;
	
	public CallResult getContact(String connectionId, String sso) 
			throws DAOException;
	
	public CallResult getAddress(String connectionId, String sso) 
			throws DAOException;
	
	public CallResult getTerminalConnections(String connectionId, String sso) 
			throws DAOException;
	
	public CallResult getState(String connectionId, String sso) 
			throws DAOException;
	
	public CallResult disconnect(String connectionId, String sso) 
			throws DAOException;
	
	public CallResult alert(String connectionId, String sso) 
			throws DAOException;
}
