package com.nortel.rc.dao;

import java.util.List;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.AttachedDataTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.IntrinsicTO;
import com.nortel.rc.exception.DAOException;

public interface IContactServiceDAO extends IServiceDAO
{
	public CallResult getCalledAddress(String contactId, String sso)
			throws DAOException;
	
	public CallResult getCallingAddress(String contactId, String sso)
			throws DAOException;
	
	public CallResult getCallingTerminal(String contactId, String sso)
			throws DAOException;
	
	public CallResult getLastRedirectedAddress(String contactId, String sso)
			throws DAOException;
	
	public CallResult getOriginalDestinationAddress(String contactId, String sso)
			throws DAOException;
	
	public CallResult getContactTypes(String contactId, String sso)
			throws DAOException;
	
	public CallResult setAttachedData(String contactId, AttachedDataTO data, String sso)
			throws DAOException;
	
	public CallResult getAttachedData(String contactId, String sso)
			throws DAOException;
	
	public CallResult setIntrinsicData(String contactId, List<IntrinsicTO> data, String sso)
			throws DAOException;

	public CallResult getIntrinsicData(String contactId, String sso)
			throws DAOException;

	public CallResult setUUIData(String contactId, String data, String sso)
			throws DAOException;

	public CallResult getUUIData(String contactId, String sso)
			throws DAOException;
	
	public CallResult getConnections(String contactId, String sso)
			throws DAOException;
	
	public CallResult getCapabilities(String contactId, String sso)
			throws DAOException;
	
	public CallResult giveMediaTreatment(AddressTO addr, ContactTO cont, String sso)
			throws DAOException;
}
