package com.nortel.rc.dao;

import java.util.List;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;

public interface INotificationDAO extends IServiceDAO
{
	public void subscribe(List<TerminalTO> terminals,  List<AddressTO> addresses, String ssoToken)
			throws DAOException;
	
    public void unSubscribe(String ssoToken) 
    		throws DAOException;
    
    public void unSubscribe(String sso, String specificSubscriptionId)
    		throws DAOException;
    
    public void renew(String sso, String specificSubscriptionId)
    		throws DAOException;
}
