package com.nortel.rc.dao;

import java.util.List;

import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ForwardInstructionTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;

public interface ITerminalServiceDAO extends IServiceDAO
{
	public CallResult getCapabilities(TerminalTO term, String sso) 
			throws DAOException;
	
	public CallResult getDoNotDisturb(TerminalTO term, String sso)
			throws DAOException;
	
	public CallResult setDoNotDisturb(TerminalTO term, String sso)
			throws DAOException;
	
	public CallResult isForwarded(TerminalTO term, String sso)
			throws DAOException;
	
	public CallResult setForwarding(TerminalTO term, List<ForwardInstructionTO> instructions, String sso)
			throws DAOException;
	
	public CallResult getForwarding(TerminalTO term, String sso)
			throws DAOException;
	
	public CallResult cancelForwarding(TerminalTO term, String sso) 
			throws DAOException;
	
	public CallResult getContactTypes(TerminalTO term, String sso)
			throws DAOException;
}
