package com.nortel.rc.dao;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.AttachedDataTO;
import com.nortel.rc.dto.AttachedDataTO.AttachedDataType;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.IntrinsicTO;
import com.nortel.rc.dto.KeyValuePairTO;
import com.nortel.rc.dto.ProviderTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.faults.CreateContactException;
import com.nortel.soa.oi.cct.faults.GetContactException;
import com.nortel.soa.oi.cct.faults.LogInToCCTServerException;
import com.nortel.soa.oi.cct.sessionservice.SOAOICCT;
import com.nortel.soa.oi.cct.sessionservice.SessionService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.Agent;
import com.nortel.soa.oi.cct.types.AttachedData;
import com.nortel.soa.oi.cct.types.AttachmentType;
import com.nortel.soa.oi.cct.types.AuthenticationLevel;
import com.nortel.soa.oi.cct.types.ByteArray;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.GetVersionRequest;
import com.nortel.soa.oi.cct.types.GetVersionResponse;
import com.nortel.soa.oi.cct.types.Intrinsic;
import com.nortel.soa.oi.cct.types.KeyValuePair;
import com.nortel.soa.oi.cct.types.KeyValuePairArray;
import com.nortel.soa.oi.cct.types.Provider;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalType;
import com.nortel.soa.oi.cct.types.sessionservice.AddressList;
import com.nortel.soa.oi.cct.types.sessionservice.AddressResponse;
import com.nortel.soa.oi.cct.types.sessionservice.ContactRequest;
import com.nortel.soa.oi.cct.types.sessionservice.ContactResponse;
import com.nortel.soa.oi.cct.types.sessionservice.CreateContactRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GenerateDTMFRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetAddressRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetAddressesRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetAgentsResponse;
import com.nortel.soa.oi.cct.types.sessionservice.GetContactDataResponse;
import com.nortel.soa.oi.cct.types.sessionservice.GetIntrinsicsResponse;
import com.nortel.soa.oi.cct.types.sessionservice.GetTerminalAddressesRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetTerminalRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetTerminalsRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogInToCCTServerRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogInToCCTServerResponse;
import com.nortel.soa.oi.cct.types.sessionservice.LogOffFromCCTServerRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LoginAgentRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LoginAgentToStateRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LoginAgentToTerminalRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogoutAgentFromTerminalRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogoutAgentRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SetActivityCodeRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SetContactDataRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SetIntrinsicsRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SetToNotReadyStateWithReasonCodeRequest;
import com.nortel.soa.oi.cct.types.sessionservice.SsoRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalAddressRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalContactAddressRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalContactContactRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalContactRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalList;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalResponse;

public class SessionServiceDAO extends ServiceDAO implements IContactDAO
{	
	private static Logger logger = Logger.getLogger("rc.dao.SessionServiceDAO");
	
	String endPoint = null;
	
    
	public CallResult loginAgent(TerminalTO term, String uname, String pwd, String sso) throws DAOException
    {        
        String methodName = "loginAgent():";
        LoginAgentRequest loginAgentRequest = new LoginAgentRequest();
        SsoToken ssoToken = new SsoToken();
        if(term != null)
        {
        	Terminal terminal = new Terminal();
        	terminal.setTerminalName(term.getTerminalName());
        	terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
        	loginAgentRequest.setTerminal(terminal);
        }
				
		ssoToken.setToken(sso);
		
		loginAgentRequest.setSsoToken(ssoToken);
        loginAgentRequest.setAgentId(uname);
        loginAgentRequest.setAgentPassword(pwd);        
		
        try {
            getPort().loginAgent(loginAgentRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);	    	
	    }

        CallResult result = new CallResult();
        return result;
    }

	public CallResult loginAgentToTerminal(TerminalTO term, AgentTO agent, int state, String sso) throws DAOException
    {        
		String methodName = "loginAgentToTerminal():";
		LoginAgentToTerminalRequest loginAgentRequest = new LoginAgentToTerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));		
		terminal.setTerminalName(term.getTerminalName());
		terminal.setStatus("Enabled");
		
		Provider provider = new Provider();
		provider.setProviderName("Passive");
				
		ssoToken.setToken(sso);
		
		loginAgentRequest.setAgentTerminal(terminal);
		loginAgentRequest.setSsoToken(ssoToken);
        loginAgentRequest.setAgentId(agent.getAgentLoginId());
        loginAgentRequest.setPassword("Password");
        loginAgentRequest.setInitialState(state);
		
        try {
            getPort().loginAgentToTerminal(loginAgentRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
        
        CallResult result = new CallResult();        
        return result;
    }
	
	public CallResult logoutAgentFromTerminal(TerminalTO term, String sso) throws DAOException
    {        
		String methodName = "logoutAgentFromTerminal():";
		LogoutAgentFromTerminalRequest logoutAgentRequest = new LogoutAgentFromTerminalRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));		
		terminal.setTerminalName(term.getTerminalName());
		terminal.setStatus("Enabled");
		
		Provider provider = new Provider();
		provider.setProviderName("Passive");
				
		ssoToken.setToken(sso);
		
		logoutAgentRequest.setAgentTerminal(terminal);
		logoutAgentRequest.setSsoToken(ssoToken);
		
        try {
            getPort().logoutAgentFromTerminal(logoutAgentRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
        
        CallResult result = new CallResult();        
        return result;
    }
	
	public CallResult loginAgentToState(TerminalTO term, AgentTO agent, int state, String sso) throws DAOException
    {   		
		String methodName = "loginAgentToState():";
		LoginAgentToStateRequest loginAgentRequest = new LoginAgentToStateRequest();
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        
        if(term != null)
        {
			terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));		
			terminal.setTerminalName(term.getTerminalName());
			terminal.setStatus("Enabled");
			loginAgentRequest.setTerminal(terminal);
        }
				
		ssoToken.setToken(sso);
		loginAgentRequest.setSsoToken(ssoToken);
        loginAgentRequest.setAgentId(agent.getAgentLoginId());
        loginAgentRequest.setAgentPassword("Password");
        loginAgentRequest.setInitialState(state);
		
        try {
            getPort().loginAgentToState(loginAgentRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
        
        CallResult result = new CallResult();        
        return result;
    }
	
	public CallResult logoutAgent(TerminalTO term, String sso) throws DAOException
    {   
		String methodName = "logoutAgent():";
		LogoutAgentRequest logoutAgentRequest = new LogoutAgentRequest();	    
	    Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));		
		terminal.setTerminalName(term.getTerminalName());
				
		ssoToken.setToken(sso);
		
		logoutAgentRequest.setTerminal(terminal);
		logoutAgentRequest.setSsoToken(ssoToken);

        try {
            getPort().logoutAgent(logoutAgentRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
        
        CallResult result = new CallResult();
        return result;	    
    }
	
    public CallResult createContact(TerminalTO term, AddressTO src, AddressTO dest, String sso) throws DAOException
    {        
    	String methodName = "createContact():";
		CreateContactRequest createContactRequest = new CreateContactRequest();
        ContactResponse response = null;        
        Terminal terminal = new Terminal();
        SsoToken ssoToken = new SsoToken();
        Address source = new Address();
        Address destination = new Address();
        
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());
		source.setAddressType(AddressType.valueOf(src.getAddressType()));
		source.setAddressName(src.getAddressName());                
		destination.setAddressName(dest.getAddressName());
		destination.setAddressType(AddressType.valueOf(dest.getAddressType()));
        ssoToken.setToken(sso);
        
        createContactRequest.setTerminal(terminal);
        createContactRequest.setSsoToken(ssoToken);
        createContactRequest.setSrcAddress(source);
        createContactRequest.setDstAddress(destination);
        
        try {        	
            response = getPort().createContact(createContactRequest);
            if (response == null)
            	throw new CreateContactException("NULL response received");
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
        
        CallResult result = new CallResult();
        result.setMessage(response.getContact().getContactId());
        return result;
    }
    
    public CallResult getContact(String externalContactId, String sso) throws DAOException
    {
    	String methodName = "getContact():";
		ContactRequest contactRequest = new ContactRequest();
        ContactResponse response = null;
        Contact contact = new Contact();
        SsoToken ssoToken = new SsoToken();
        
        contact.setExternalContactId(externalContactId);
        ssoToken.setToken(sso);
        
        contactRequest.setContact(contact);
        contactRequest.setSsoToken(ssoToken);
        
        try {
            response = getPort().getContact(contactRequest);
            if (response == null)
            	throw new GetContactException("NULL response received");            	
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
        
        CallResult result = new CallResult();
        result.setMessage(response.getContact().getContactId());
        return result;
    }
    
    public CallResult answerContact(String contactId, TerminalTO term, String sso) throws DAOException
    {
    	String methodName = "answerContact():";
		TerminalContactRequest contactRequest = new TerminalContactRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());		
	    contact.setContactId(contactId);	    
	    ssoToken.setToken(sso);
	    
	    contactRequest.setTerminal(terminal);
	    contactRequest.setSsoToken(ssoToken);
	    contactRequest.setContact(contact);
	    
	    try {        	
	        getPort().answerContact(contactRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult transferContact(TerminalTO term, AddressTO dest, String contactId, String sso) throws DAOException
    {        
    	String methodName = "transferContact():";
		TerminalContactAddressRequest transferContactRequest = new TerminalContactAddressRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Address destination = new Address();
	    Contact contact = new Contact();
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());		
		destination.setAddressName(dest.getAddressName());
		destination.setAddressType(AddressType.valueOf(dest.getAddressType()));	    
		contact.setContactId(contactId);	    
	    ssoToken.setToken(sso);
	    
	    transferContactRequest.setTerminal(terminal);
	    transferContactRequest.setSsoToken(ssoToken);
	    transferContactRequest.setAddress(destination);
	    transferContactRequest.setContact(contact);
	    
	    try {        	
	        getPort().transferContact(transferContactRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult initiateSupervisedTransfer(TerminalTO term, AddressTO dest, String contactId, String sso) throws DAOException
    {        
    	String methodName = "initiateSupervisedTransfer():";
		TerminalContactAddressRequest transferContactRequest = new TerminalContactAddressRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Address destination = new Address();
	    Contact contact = new Contact();
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());		
		destination.setAddressName(dest.getAddressName());
		destination.setAddressType(AddressType.valueOf(dest.getAddressType()));	    
		contact.setContactId(contactId);	    
	    ssoToken.setToken(sso);
	    
	    transferContactRequest.setTerminal(terminal);
	    transferContactRequest.setSsoToken(ssoToken);
	    transferContactRequest.setAddress(destination);
	    transferContactRequest.setContact(contact);
	    
	    try {        	
	        getPort().initiateSupervisedTransfer(transferContactRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult completeSupervisedTransfer(TerminalTO term, String consultedContactId, String contactId, String sso) throws DAOException
    {        
    	String methodName = "completeSupervisedTransfer():";
		TerminalContactContactRequest compXferRequest = new TerminalContactContactRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    Contact consultedContact = new Contact();
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());    
		contact.setContactId(contactId);
		consultedContact.setContactId(consultedContactId);		
	    ssoToken.setToken(sso);
	    
	    compXferRequest.setTerminal(terminal);
	    compXferRequest.setSsoToken(ssoToken);
	    compXferRequest.setConsultedContact(consultedContact);
	    compXferRequest.setContact(contact);
	    
	    try {        	
	        getPort().completeSupervisedTransfer(compXferRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult dropContact(String contactId, TerminalTO term, String sso) throws DAOException
    {        
    	String methodName = "dropContact():";
		TerminalContactRequest contactRequest = new TerminalContactRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());		
	    contact.setContactId(contactId);	    
	    ssoToken.setToken(sso);
	    
	    contactRequest.setTerminal(terminal);
	    contactRequest.setSsoToken(ssoToken);
	    contactRequest.setContact(contact);
	    
	    try {        	
	        getPort().dropContact(contactRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult holdContact(String contactId, TerminalTO term, String sso) throws DAOException
    {	    
    	String methodName = "holdContact():";
		TerminalContactRequest contactRequest = new TerminalContactRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());		
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    contactRequest.setTerminal(terminal);
	    contactRequest.setSsoToken(ssoToken);
	    contactRequest.setContact(contact);

	    try {        	
	        getPort().holdContact(contactRequest);	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
	}
    
    public CallResult unHoldContact(String contactId, TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "unHoldContact():";
		TerminalContactRequest contactRequest = new TerminalContactRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());
	    contact.setContactId(contactId);	    
	    ssoToken.setToken(sso);
	    
	    contactRequest.setTerminal(terminal);
	    contactRequest.setSsoToken(ssoToken);
	    contactRequest.setContact(contact);
	    
	    try {       	
	    	getPort().unHoldContact(contactRequest);
	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult initiateConference(TerminalTO term, AddressTO dest, String contactId, String sso) throws DAOException
    {        
    	String methodName = "initiateConference():";
		TerminalContactAddressRequest initiateConfRequest = new TerminalContactAddressRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Address destination = new Address();
	    Contact contact = new Contact();
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());		
		destination.setAddressName(dest.getAddressName());
		destination.setAddressType(AddressType.valueOf(dest.getAddressType()));	    
		contact.setContactId(contactId);	    
	    ssoToken.setToken(sso);
	    
	    initiateConfRequest.setTerminal(terminal);
	    initiateConfRequest.setSsoToken(ssoToken);
	    initiateConfRequest.setAddress(destination);
	    initiateConfRequest.setContact(contact);
	    
	    try {
	        getPort().initiateConference(initiateConfRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult completeConference(TerminalTO term, String consultedContactId, String contactId, String sso) throws DAOException
    {        
    	String methodName = "completeConference():";
		TerminalContactContactRequest compConfRequest = new TerminalContactContactRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    Contact consultedContact = new Contact();
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());    
		contact.setContactId(contactId);
		consultedContact.setContactId(consultedContactId);		
	    ssoToken.setToken(sso);
	    
	    compConfRequest.setTerminal(terminal);
	    compConfRequest.setSsoToken(ssoToken);
	    compConfRequest.setConsultedContact(consultedContact);
	    compConfRequest.setContact(contact);
	    
	    try {        	
	        getPort().completeConference(compConfRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
	public CallResult cctLogin(String uname, String pwd, String domain)	throws DAOException {
		String methodName = "cctLogin():";
		LogInToCCTServerRequest request = new LogInToCCTServerRequest();
		AuthenticationLevel authenticationLevel = new AuthenticationLevel();
		authenticationLevel.setUsername(uname);
		authenticationLevel.setPassword(pwd);
		authenticationLevel.setDomain(domain);
		request.setAuthenticationLevel(authenticationLevel);

		LogInToCCTServerResponse response = null;

		try {
			response = getPort().logInToCCTServer(request);
			if (response == null)
				throw new LogInToCCTServerException("NULL response received");
		} catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" "+ getWsdlUrl().getHost() +"::"+getPort().toString());
	    }
		CallResult result = new CallResult();
		result.setMessage(response.getSsoToken().getToken());
		return result;
	}
    
    public CallResult cctLogout(String ssoToken) throws DAOException
	{		
    	String methodName = "cctLogout():";
		LogOffFromCCTServerRequest request = new LogOffFromCCTServerRequest();
		SsoToken token = new SsoToken();
		token.setToken(ssoToken);
		request.setSsoToken(token);
		       
		try
		{
			getPort().logOffFromCCTServer(request);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        CallResult result = new CallResult();
        return result;
	}
    
    public CallResult emergencyKey(String contactId, TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "emergencyKey():";
		TerminalContactRequest request = new TerminalContactRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());
	    contact.setContactId(contactId);	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    request.setContact(contact);
	    
	    try {       	
	    	getPort().emergencyKey(request);
	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult callSupervisor(TerminalTO term, AddressTO addr, String sso) throws DAOException
    {  
    	String methodName = "callSupervisor():";
		TerminalAddressRequest request = new TerminalAddressRequest();
	    Terminal terminal = new Terminal();
	    Address address = new Address();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());
		address.setAddressType(AddressType.valueOf(addr.getAddressType()));
		address.setAddressName(addr.getAddressName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setAddress(address);
	    request.setSsoToken(ssoToken);
	    
	    try {       	
	    	getPort().callSupervisor(request);	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult setToReadyState(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "setToReadyState():";
		TerminalRequest request = new TerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    
	    try {       	
	    	getPort().setToReadyState(request);
	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult setToNotReadyState(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "setToNotReadyState():";
		TerminalRequest request = new TerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    
	    try {       	
	    	getPort().setToNotReadyState(request);
	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult setToNotReadyStateWithReasonCode(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "setToNotReadyStateWithReasonCode():";
		SetToNotReadyStateWithReasonCodeRequest request = new SetToNotReadyStateWithReasonCodeRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    request.setReasonCode(term.getTerminalNotReadyReason());
	    
	    try {       	
	    	getPort().setToNotReadyStateWithReasonCode(request);
	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult makeSetBusy(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "makeSetBusy():";
		TerminalRequest request = new TerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    
	    try {       	
	    	getPort().makeSetBusy(request);
	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public List<TerminalTO> getUserTerminals(String ssoToken) throws DAOException
    {
    	String methodName = "getUserTerminals():";
		List<TerminalTO> results = new ArrayList<TerminalTO>();
    	GetTerminalsRequest terminalsRequest = new GetTerminalsRequest();
    	TerminalList returnedTerminalList;
    	
    	SsoToken token = new SsoToken();
		token.setToken(ssoToken);
		terminalsRequest.setSsoToken(token);
		
		try
		{
        	returnedTerminalList = getPort().getTerminals(terminalsRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        
        if(returnedTerminalList != null)
        {
	        for(Terminal cctTerminal : returnedTerminalList.getTerminals())
	        {
	        	TerminalTO terminal = new TerminalTO();
	        	terminal.setTerminalName(cctTerminal.getTerminalName());
	        	terminal.setTerminalType(cctTerminal.getTerminalType().value());
	        	terminal.setTerminalStatus(cctTerminal.getStatus());
	        	ProviderTO provider = new ProviderTO();
	        	provider.setProviderName(cctTerminal.getProvider() != null ? cctTerminal.getProvider().getProviderName() : "");
	        	terminal.setProvider(provider);
	        	results.add(terminal);
	        }
        }
        
        return results;
    }
    
    public List<AddressTO> getTerminalAddresses(TerminalTO term, String ssoToken) throws DAOException
    {
    	String methodName = "getTerminalAddresses():";
		List<AddressTO> results = new ArrayList<AddressTO>();
    	GetTerminalAddressesRequest addressesRequest = new GetTerminalAddressesRequest();
    	AddressList returnedAddressList;
    	Terminal terminal = new Terminal();    	
    	SsoToken token = new SsoToken();
    	//test
    	Provider provider = new Provider();
    	provider.setProviderName("Passive");
    	
    	terminal.setTerminalName(term.getTerminalName());
    	terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		token.setToken(ssoToken);
		addressesRequest.setSsoToken(token);
		addressesRequest.setTerminal(terminal);
           
		try
		{
        	returnedAddressList = getPort().getTerminalAddresses(addressesRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        
        if(returnedAddressList != null)
        {
	        for(Address cctAddress : returnedAddressList.getAddresses())
	        {
	        	AddressTO address = new AddressTO();
	        	address.setAddressName(cctAddress.getAddressName());
	        	address.setAddressType(cctAddress.getAddressType().value());
	        	address.setAddressStatus(cctAddress.getStatus());
	        	results.add(address);
	        }
        }
        
        return results;    	
    }
    
    public List<AddressTO> getUserAddresses(String ssoToken) throws DAOException
    {
    	String methodName = "getUserAddresses():";
		List<AddressTO> results = new ArrayList<AddressTO>();
    	GetAddressesRequest addressesRequest = new GetAddressesRequest();
    	AddressList returnedAddressList;
    	
    	SsoToken token = new SsoToken();
		token.setToken(ssoToken);
		addressesRequest.setSsoToken(token);
    	        
		try
		{
        	returnedAddressList = getPort().getAddresses(addressesRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        
        if(returnedAddressList != null)
        {
	        for(Address cctAddress : returnedAddressList.getAddresses())
	        {
	        	AddressTO address = new AddressTO();
	        	address.setAddressName(cctAddress.getAddressName());
	        	address.setAddressType(cctAddress.getAddressType().value());
	        	address.setAddressStatus(cctAddress.getStatus());
	        	results.add(address);
	        }
        }
        return results;    	
    }
    
    public AddressTO getAddress(String ssoToken, String addressName) throws DAOException
    {
    	String methodName = "getAddress():";
		AddressTO resultAddress = null;
    	Address cctAddress = null;
    	GetAddressRequest addressRequest = new GetAddressRequest();	
    	SsoToken token = new SsoToken();
		token.setToken(ssoToken);
		
		addressRequest.setAddressName(addressName);
		addressRequest.setSsoToken(token);
    	    
		AddressResponse response = null;
		try
		{
        	response = getPort().getAddress(addressRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        
        if(response != null && response.getAddressResponse() != null)
        {
        	cctAddress = response.getAddressResponse();
        	resultAddress = new AddressTO();
        	resultAddress.setAddressName(cctAddress.getAddressName());
        	resultAddress.setAddressStatus(cctAddress.getStatus());
        	resultAddress.setAddressType(cctAddress.getAddressType().value());
        }
        return resultAddress;
    }
    
    public TerminalTO getTerminal(String ssoToken, String terminalName) throws DAOException
    {
    	String methodName = "getTerminal():";
		TerminalTO resultTerminal = null;
    	Terminal cctTerminal = null;
    	GetTerminalRequest terminalRequest = new GetTerminalRequest();	
    	SsoToken token = new SsoToken();
		token.setToken(ssoToken);
		
		terminalRequest.setTerminalName(terminalName);
		terminalRequest.setSsoToken(token);
    	    
		TerminalResponse response = null;
		try
		{
        	response = getPort().getTerminal(terminalRequest);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        
        if(response != null && response.getTerminalResponse() != null)
        {
        	cctTerminal = response.getTerminalResponse();
        	resultTerminal = new TerminalTO();
        	resultTerminal.setTerminalName(cctTerminal.getTerminalName());
        	resultTerminal.setTerminalStatus(cctTerminal.getStatus());
        	resultTerminal.setTerminalType(cctTerminal.getTerminalType().value());
        }
        return resultTerminal;
    }
    
    public List<AgentTO> getAgents(String ssoToken) throws DAOException
    {
    	String methodName = "getAgents():";
		List<AgentTO> results = new ArrayList<AgentTO>();
    	SsoRequest request = new SsoRequest();
    	GetAgentsResponse response;
    	
    	SsoToken token = new SsoToken();
		token.setToken(ssoToken);
		request.setSsoToken(token);
    	        
		try
		{
			response = getPort().getAgents(request);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        
        if(response != null)
        {
	        for(Agent cctAgent : response.getAgents())
	        {
	        	AgentTO agent = new AgentTO();
	        	agent.setAgentLoginId(cctAgent.getAgentLoginId());
	        	agent.setAgentUsername(cctAgent.getUserName());
	        	//agent.setAgentType(cctAgent.getAgentType().value());
	        	results.add(agent);
	        }
        }
        return results;    	
    }
    
    public CallResult setActivityCode(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "setActivityCode():";
		SetActivityCodeRequest request = new SetActivityCodeRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    request.setActivityCode(term.getTerminalActivityCode());
	    
	    try {       	
	    	getPort().setActivityCode(request);
	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult generateDTMF(TerminalTO term, ContactTO cont, String digits, String sso) throws DAOException
    {  
    	String methodName = "generateDTMF():";
		GenerateDTMFRequest request = new GenerateDTMFRequest();
	    Terminal terminal = new Terminal();
	    Contact contact = new Contact();
	    SsoToken ssoToken = new SsoToken();	    
	    
	    if (term == null)
	    	throw new DAOException(new IllegalArgumentException("term parameter is NULL"));
	    
	    if (cont == null)
	    	throw new DAOException(new IllegalArgumentException("cont parameter is NULL"));
	    
	    
	    terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());
		contact.setContactId(cont.getContactId());
	    ssoToken.setToken(sso);	    
	    
	    request.setSsoToken(ssoToken);
	    request.setTerminal(terminal);
	    request.setContact(contact);
	    request.setDigits(digits != null ? digits : "");
	    
	    try {       	
	    	getPort().generateDTMF(request);
	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    
    public CallResult setContactData(String contactId, AttachedDataTO dataToAttach, String sso) throws DAOException
    {
    	String methodName = "setContactData():";
		SetContactDataRequest dataRequest = new SetContactDataRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    AttachedData data = null;
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    if(dataToAttach != null)
	    {
	    	data = new AttachedData();
		    if(dataToAttach.getType().equals(AttachedDataType.STRING))
		    {	    
			    data.setType(AttachmentType.STRING);
			    data.setStringData(dataToAttach.getStringData());
		    }
		    else if(dataToAttach.getType().equals(AttachedDataType.BINARY))
		    {		    
			    data.setType(AttachmentType.BINARY);
		    	ByteArray byteArray = new ByteArray();
		    	for(byte b : dataToAttach.getBinaryData())
	    		{
		    		byteArray.getItem().add(Byte.valueOf(b));
	    		}
			    data.setBinaryData(byteArray);
		    }
		    else
		    {
		    	data.setType(AttachmentType.KEY_VALUE_PAIRS);
		    	KeyValuePairArray kvps = new KeyValuePairArray();
		    	for(KeyValuePairTO kvpTO : dataToAttach.getKeyValueData())
		    	{
		    		KeyValuePair kvp = new KeyValuePair();
		    		kvp.setKey(kvpTO.getKey());
		    		kvp.setValue(kvpTO.getValue());
		    		kvps.getItem().add(kvp);
		    	}
			    data.setKeyValueData(kvps);
		    }
	    }
	    
	    dataRequest.setContact(contact);
	    dataRequest.setContactData(data);
	    dataRequest.setSsoToken(ssoToken);
	    
	    try {
	        getPort().setContactData(dataRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult getContactData(String contactId, String sso) throws DAOException
    {
    	String methodName = "getContactData():";
		ContactRequest contactRequest = new ContactRequest();
        AttachedDataTO contactData = new AttachedDataTO();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    contactRequest.setContact(contact);
	    contactRequest.setSsoToken(ssoToken);
	    
	    AttachedData cctAttachedData;
	    GetContactDataResponse response = null;
	    try {
	    	response = getPort().getContactData(contactRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    if(response != null && response.getContactData() != null && response.getContactData().getType() != null)
	    {
	    	cctAttachedData = response.getContactData();
	    	if(cctAttachedData.getType().value().equals("STRING"))
	    	{
	    		contactData.setType(AttachedDataType.STRING);
	    		contactData.setStringData(cctAttachedData.getStringData());
	    	}
	    	else if(cctAttachedData.getType().value().equals("BINARY"))
	    	{
	    		contactData.setType(AttachedDataType.BINARY);
	    		
	    		byte[] binaryData = new byte[cctAttachedData.getBinaryData().getItem().size()];
	    		int byteCount = 0;
	    		for(Byte b : cctAttachedData.getBinaryData().getItem())
	    		{
	    			binaryData[byteCount++] = b.byteValue();
	    		}
	    		contactData.setBinaryData(binaryData);
	    	}
	    	else
	    	{
	    		contactData.setType(AttachedDataType.KVP);
	    		KeyValuePairTO[] kvps = new KeyValuePairTO[cctAttachedData.getKeyValueData().getItem().size()];
	    		int counter = 0;
	    		for(KeyValuePair cctKvp : cctAttachedData.getKeyValueData().getItem())
	    		{
	    			KeyValuePairTO kvp = new KeyValuePairTO();
	    			kvp.setKey(cctKvp.getKey());
	    			kvp.setValue(cctKvp.getValue());
	    			kvps[counter] = kvp;
	    			counter++;
	    		}
	    		contactData.setKeyValueData(kvps);
	    	}
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(contactData);
        return result;
    }
    
    public int getCurrentAddressCount(String ssoToken) throws DAOException
    {
    	String methodName = "getCurrentAddressCount():";
		int count = 0;
    	SsoRequest request = new SsoRequest();
    	
    	SsoToken token = new SsoToken();
		token.setToken(ssoToken);
		request.setSsoToken(token);
    	        
		try
		{
			count = getPort().getCurrentAddressCount(request);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        
        return count;
    }
    
    public int getCurrentTerminalCount(String ssoToken) throws DAOException
    {
    	String methodName = "getCurrentTerminalCount():";
		int count = 0;
    	SsoRequest request = new SsoRequest();
    	
    	SsoToken token = new SsoToken();
		token.setToken(ssoToken);
		request.setSsoToken(token);
    	        
		try
		{
			count = getPort().getCurrentTerminalCount(request);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        
        return count;
    }
    
    public String getVersion(String ssoToken) throws DAOException
    {
    	String methodName = "getVersion():";
		String version = "";
    	GetVersionRequest request = new GetVersionRequest();
    	GetVersionResponse response = null;        
		try
		{
			response = getPort().getVersion(request);
        } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+ssoToken+"] endpoint : "+ endPoint);
	    }
        if(response != null)
        {
        	version = response.getVersion();
        }
        return version;
    }
    
    public CallResult setIntrinsicData(String contactId, List<IntrinsicTO> intrinsicData, String sso) throws DAOException
    {
    	String methodName = "setIntrinsicData():";
		SetIntrinsicsRequest dataRequest = new SetIntrinsicsRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);	    
	    ssoToken.setToken(sso);
	    
	    dataRequest.setContact(contact);
	    dataRequest.setSsoToken(ssoToken);
	    
	    for(IntrinsicTO intrinsic : intrinsicData)
	    {
	    	if(intrinsic.getKey() != null && !intrinsic.getKey().equals("") && !intrinsic.isImmutable())
	    	{
		    	Intrinsic intr = new Intrinsic();
		    	intr.setKey(intrinsic.getKey());
		    	intr.setValue(intrinsic.getValue());
		    	intr.setImmutable(intrinsic.isImmutable());
		    	dataRequest.getIntrinsics().add(intr);
	    	}
	    }
	    
	    try {
	        getPort().setIntrinsics(dataRequest);
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult getIntrinsicData(String contactId, String sso) throws DAOException
    {
    	String methodName = "getIntrinsicData():";
		ContactRequest contactRequest = new ContactRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    contactRequest.setContact(contact);
	    contactRequest.setSsoToken(ssoToken);
	    
	    List<Intrinsic> intrinsicsList = null;
	    try {
	    	
	    	GetIntrinsicsResponse response = getPort().getIntrinsics(contactRequest);
	    	if (response != null)
	    		intrinsicsList =response.getIntrinsic();
	    	
	    } catch (Exception e) {
        	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    List<IntrinsicTO> intrinsics = null;
	    if(intrinsicsList != null)
	    {
	    	intrinsics = new ArrayList<IntrinsicTO>(intrinsicsList.size());
		    for(Intrinsic intr : intrinsicsList)
		    {
		    	IntrinsicTO intrinsic = new IntrinsicTO();
		    	intrinsic.setKey(intr.getKey());
		    	intrinsic.setValue(intr.getValue());
		    	intrinsic.setImmutable(intr.isImmutable());
		    	intrinsics.add(intrinsic);
		    }
	    }	    
	    
	    CallResult result = new CallResult();
	    result.setObject(intrinsics);
        return result;
    }
    
    /**
	 * @return {@link SessionService}
	 * Retrieves interface to be used by service consumers
	 */
	public SessionService getPort() throws DAOException
	{		
		if(endPoint == null){
			SOAOICCT ss = new SOAOICCT(getWsdlUrl(), getServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}
		
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setServiceClass(SessionService.class);
		SessionService service = (SessionService) factory.create();
		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);
		
		return service;
	}
}
