package sample.subscribe;

import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;

import org.oasis_open.docs.wsrf._2004._06.wsrf_ws_resourceproperties_1_2_draft_01.QueryExpressionType;
import org.xmlsoap.schemas.ws._2003._03.addressing.AttributedURI;
import org.xmlsoap.schemas.ws._2003._03.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws._2003._03.addressing.ServiceNameType;

import sample.consumer.Consumer2Impl;

import com.nortel.soa.oi.cct.agentterminalservice.AgentTerminalService;
import com.nortel.soa.oi.cct.agentterminalservice.SOAOICCTAgentTerminalService;
import com.nortel.soa.oi.cct.basenotification.AgentPropertyListenerType;
import com.nortel.soa.oi.cct.basenotification.NotificationTopicType;
import com.nortel.soa.oi.cct.basenotification.TerminalPropertyListenerType;
import com.nortel.soa.oi.cct.basenotification.TopicExpressionType;
import com.nortel.soa.oi.cct.notification.SubscriptionPolicyType;
import com.nortel.soa.oi.cct.notificationproducer.NotificationProducer;
import com.nortel.soa.oi.cct.notificationproducer.ResourceUnknownFault;
import com.nortel.soa.oi.cct.notificationproducer.SOAOICCTNotificationProducer;
import com.nortel.soa.oi.cct.notificationproducer.UnableToDestroySubscriptionFault;
import com.nortel.soa.oi.cct.types.Agent;
import com.nortel.soa.oi.cct.types.AgentProperty;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.TerminalProperty;

public class NotificationProducerSubscribe {

	private static String localIpAddress;
	NotificationProducer npService  = null;
	AgentTerminalService agentTerminalService = null;
	private String consumerPort = "9091";
	private SsoToken ssoToken = null;
	
	public NotificationProducerSubscribe(String port, String serverDetails, SsoToken ssoToken) {
		if (port != null) {
			this.consumerPort = port;
		}
		this.ssoToken = ssoToken;
		
		getIpAddress();
		
		try {
			getNotificationProducerService(serverDetails);
			getAgentTerminalService(serverDetails);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public NotificationProducer getNotificationProducerService(String serverDetails) throws Exception {
        if (npService == null) {
			try {
	        	 String sslocation = "http://" + serverDetails +  "/SOAOICCT/services/NotificationProducer?wsdl";
	             System.out.println("About to get : " + sslocation);
	        	 URL url = new URL(sslocation);
	        	 npService = new SOAOICCTNotificationProducer(url).getNotificationProducer();
	             
	        } catch (Exception e) {
	        	e.printStackTrace();
	        	throw e;
	        }
        }
        return npService;
    }
	
	
	public AgentTerminalService getAgentTerminalService(String serverDetails) throws Exception {
        if (agentTerminalService == null) {
			 String sslocation = "http://" + serverDetails +  "/SOAOICCT/services/AgentTerminalService?wsdl";
             System.out.println("About to get : " + sslocation);
        	 URL url = new URL(sslocation);
        	 agentTerminalService = new SOAOICCTAgentTerminalService(url).getAgentTerminalService();
        }
        return agentTerminalService;
    }
	
	public String publishNotificationConsumer() {
		String notificationConsumerUri  = "http://" + getIpAddress() + ":" + consumerPort + "/SOAOICCT/services/NotificationConsumer";
		
		
		Consumer2Impl notificationConsumerImpl = new Consumer2Impl(agentTerminalService, ssoToken);
	    Endpoint.publish(notificationConsumerUri, notificationConsumerImpl);
	    return notificationConsumerUri;
	}
	
	private String getIpAddress() {
        if (localIpAddress == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                localIpAddress = addr.getHostAddress();
                System.out.println("IP Address : " + localIpAddress.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        return localIpAddress;
    }
	
	
	 
	
	
	
	 public EndpointReferenceType subscribe(String consumerEndpoint, SsoToken ssoToken) throws Exception {
	    	
		 System.out.println("About to Subscribe via Notification Producer service ");
		 System.out.println("Endpoint : " + consumerEndpoint);
	    	//Setup the endpoint reference type object 
	    	//This object details the endpoint where notifications will be sent to
	        EndpointReferenceType consumerReference = new EndpointReferenceType();
	        AttributedURI value = new AttributedURI();
	        value.setValue(consumerEndpoint);
	       
	        QName name = new QName("http://www.nortel.com/soa/oi/cct/NotificationConsumer", "SOAOICCT_NotificationConsumer");   
	        consumerReference.setAddress(value);
	        consumerReference.setServiceName(new ServiceNameType());
	        consumerReference.getServiceName().setPortName("NotificationConsumer");
	        consumerReference.getServiceName().setValue(name);
	        
	    	
	    	 Boolean useNotify = true;
	         QueryExpressionType precondition = null;
	         QueryExpressionType selector = null;
	         XMLGregorianCalendar initialTerminationTime = null;

	         SubscriptionPolicyType subscriptionPolicy = new SubscriptionPolicyType();
	         subscriptionPolicy.setSessionTerminationImminentNotificationsEnabled(true);
	         subscriptionPolicy.setSessionTerminationNotificationsEnabled(true);
	         subscriptionPolicy.setSubscriptionTerminationImminentNotificationsEnabled(true);
	         subscriptionPolicy.setSubscriptionTerminationNotificationsEnabled(true);
	         
	         
	        
	         
	         //Detail the types of notifications that you are going to subscribe for
	         TopicExpressionType topicExp = new TopicExpressionType();
	         topicExp.setDialect("Simple");
	         NotificationTopicType notificationTopic = new NotificationTopicType();
	         
	         /*
	         AgentPropertyListenerType agentPropertyListenerType = new AgentPropertyListenerType();
	         List<AgentProperty> agentPropertyListenerEvents = new ArrayList<AgentProperty>();
	         agentPropertyListenerEvents.add(AgentProperty.LOGIN_STATUS);
	         agentPropertyListenerType.getAgentPropertyEvent().addAll(agentPropertyListenerEvents);
	         List<Agent> agentListenerEntities = new ArrayList<Agent>();
	         agentPropertyListenerType.getAgentEntity().addAll(agentListenerEntities);
	         notificationTopic.setAgentPropertyListener(agentPropertyListenerType);
	         */
	         
	         TerminalPropertyListenerType terminalPropertyListenerType = new TerminalPropertyListenerType();
	         List<TerminalProperty> terminalPropertyEvents = new ArrayList<TerminalProperty>();
	         terminalPropertyEvents.add(TerminalProperty.AGENT_LOGIN_SESSION);
	         terminalPropertyEvents.add(TerminalProperty.AGENT_LOGIN_SESSION_ENDED);
	         terminalPropertyEvents.add(TerminalProperty.READY_STATUS);
	         terminalPropertyListenerType.getTerminalPropertyEvent().addAll(terminalPropertyEvents);
	         notificationTopic.setTerminalPropertyListener(terminalPropertyListenerType);
	         
	         QName _TopicExpressionTypeNotificationTopic_QNAME = new QName("http://www.nortel.com/soa/oi/cct/BaseNotification", "NotificationTopic");
	         JAXBElement<NotificationTopicType> notificationTopicType = new JAXBElement<NotificationTopicType>(_TopicExpressionTypeNotificationTopic_QNAME, NotificationTopicType.class, TopicExpressionType.class, notificationTopic);
	         
	         topicExp.getContent().add(notificationTopicType);

	         
	         //Call the subscribe service
	         try {
	        	 EndpointReferenceType subscriptionEndpoint = npService.subscribe(
	                 consumerReference, 
	                 topicExp, 
	                 useNotify, 
	                 precondition, 
	                 selector, 
	                 subscriptionPolicy, 
	                 initialTerminationTime, 
	                 ssoToken);
	        	 return subscriptionEndpoint;
	         }
	         catch (Exception e ) {
	        	 e.printStackTrace();
	        	 throw e;
	         }
	         
	     }
	
	 public void unsubscribe(EndpointReferenceType subRef, SsoToken ssoToken) {
		 try {
			 System.out.println("About to Unsubscribe via Notification Producer service ");
			 npService.unsubscribe(subRef, ssoToken);
			 
		} catch (UnableToDestroySubscriptionFault e) {
			e.printStackTrace();
		} catch (ResourceUnknownFault e) {
			e.printStackTrace();
		}
	 }
	
}
