package sample.subscribe;

import java.net.InetAddress;
import java.net.URL;

import com.nortel.soa.oi.cct.types.AuthenticationLevel;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.sessionservice.LogInToCCTServerRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogInToCCTServerResponse;
import com.nortel.soa.oi.cct.types.sessionservice.LogOffFromCCTServerRequest;
import com.nortel.soa.oi.cct.userservice.LogInToCCTServerException;
import com.nortel.soa.oi.cct.userservice.SOAOICCTUserService;

import com.nortel.soa.oi.cct.userservice.UserService;


public class UserImpl {

	private static String localIpAddress;
	private UserService userService  = null;
	private String consumerPort = "9091";
	private SsoToken ssoToken = null;
	
	public UserImpl(String port, String serverDetails) {
		if (port != null) {
			this.consumerPort = port;
		}
		getIpAddress();
		
		try {
			getUserService(serverDetails);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public UserService getUserService(String serverDetails) throws Exception {
        if (userService == null) {
			 String sslocation = "http://" + serverDetails +  "/SOAOICCT/services/UserService?wsdl";
             System.out.println("About to get : " + sslocation);
        	 URL url = new URL(sslocation);
             userService = new SOAOICCTUserService(url).getUserService();
	        
        }
        return userService;
    }
	
	public SsoToken loginToCctServer(String user, String password, String domain) {
		
		System.out.println("About to login to CCT Server");
		
		LogInToCCTServerRequest req = new LogInToCCTServerRequest();
		AuthenticationLevel auth = new AuthenticationLevel();
		auth.setDomain(domain);
		auth.setPassword(password);
		auth.setUsername(user);
		req.setAuthenticationLevel(auth);
			
		 
		try {
			LogInToCCTServerResponse  token = userService.logInToCCTServer(req);		
			if (token != null) {
				ssoToken = token.getSsoToken();
				System.out.println("Got Session Token : " + ssoToken.getToken());		
				return ssoToken;
			}
		} catch (LogInToCCTServerException e) {
			//Handle Exception
		}
		return null;
	}
	
	public void logout(SsoToken ssoToken) {
		LogOffFromCCTServerRequest req = new LogOffFromCCTServerRequest();
		req.setSsoToken(ssoToken);
		try {
			userService.logOffFromCCTServer(req);
			System.out.println("Logged Off Session: " + ssoToken.getToken());
		} catch (Exception e){
			e.printStackTrace();
		}
	}
	
	private String getIpAddress() {
        if (localIpAddress == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                localIpAddress = addr.getHostAddress();
                System.out.println("IP Address : " + localIpAddress.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        return localIpAddress;
    }
}
