package sample.soa.cct;

import java.util.List;

import org.xmlsoap.schemas.ws._2003._03.addressing.EndpointReferenceType;

import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * UserAPIForm.java
 *
 * Created on 23-Mar-2009, 13:52:25
 */

/**
 *
 * @author AOIFEPO
 */
public class UserAPIForm extends javax.swing.JFrame {
 
	private static final long serialVersionUID = 1L;
	
	private SsoToken ssoToken;
    private Terminal terminal;
    private Address srcAddress;

    //LOGIN DETAILS
    private String user = "";
    private String password = "";
    private String domain = "";
    
    private String serverDetails;
    private String serverPort;
    
    public UserAPIForm() {
        initComponents();
    }
    
    /** Creates new form UserAPIForm */
    public UserAPIForm(String serverDetails, String serverPort) {
    	this.serverDetails = serverDetails;
    	this.serverPort = serverPort;
        initComponents();
        getUserDetails();
    	SubscribeUtil.publishNotificationConsumer();
      	updateInfo("Notification Consumer Published");
    }
    
    private void getUserDetails() {
    	if (System.getProperty("user") != null)
    		user = System.getProperty("user");

    	if (System.getProperty("password") != null)
    		password = System.getProperty("password");
    	
    	if (System.getProperty("domain") != null)
    		domain = System.getProperty("domain");
    	
    	System.out.println("User = " + user);
    	System.out.println("domain = " + domain);
    	
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * alway               if (srcAddress == null) {
                   srcAddress = a;s regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        btnConnect = new javax.swing.JButton();
        panelFullAPICommands = new javax.swing.JPanel();
        lblTerminal = new javax.swing.JLabel();
        lblAddress = new javax.swing.JLabel();
        cboTerminals = new javax.swing.JComboBox();
        cboAddresses = new javax.swing.JComboBox();
        btnCreate = new javax.swing.JButton();
        btnLogin = new javax.swing.JButton();
        lblDestAddress = new javax.swing.JLabel();
        lblAgentID = new javax.swing.JLabel();
        txtDestAddress = new javax.swing.JTextField();
        txtAgentID = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        lblInfo = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("SOA CCT Example");

        btnConnect.setText("Connect");
        btnConnect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connectActionPerformed(evt);
            }
        });

        panelFullAPICommands.setBorder(javax.swing.BorderFactory.createTitledBorder("Full API Commands"));

        lblTerminal.setText("Terminal :");

        lblAddress.setText("Address :");

        btnCreate.setText("Create");
        btnCreate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                createContactActionPerformed(evt);
            }
        });

        btnLogin.setText("Login");
        btnLogin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loginActionPerformed(evt);
            }
        });
        
        lblDestAddress.setText("Destination Address:");

        lblAgentID.setText("Agent ID:");

        javax.swing.GroupLayout panelFullAPICommandsLayout = new javax.swing.GroupLayout(panelFullAPICommands);
        panelFullAPICommands.setLayout(panelFullAPICommandsLayout);
        panelFullAPICommandsLayout.setHorizontalGroup(
            panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelFullAPICommandsLayout.createSequentialGroup()
                .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(cboTerminals, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblTerminal)
                    .addComponent(btnLogin, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnCreate, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                		)
                .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(panelFullAPICommandsLayout.createSequentialGroup()
                        .addGap(34, 34, 34)
                        .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(cboAddresses, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblAddress)))
                    .addGroup(panelFullAPICommandsLayout.createSequentialGroup()
                        .addGap(1, 1, 1)
                        .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblAgentID)
                            .addComponent(lblDestAddress))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(txtDestAddress, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(txtAgentID, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );
        panelFullAPICommandsLayout.setVerticalGroup(
            panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelFullAPICommandsLayout.createSequentialGroup()
                .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblTerminal)
                    .addComponent(lblAddress))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(cboAddresses, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cboTerminals, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(lblAgentID)
                        .addComponent(btnLogin)
                    		)
                    .addComponent(txtAgentID, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(panelFullAPICommandsLayout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addGroup(panelFullAPICommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(txtDestAddress, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblDestAddress)))
                    .addGroup(panelFullAPICommandsLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnCreate)))
                        
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        updateInfo("");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblInfo, javax.swing.GroupLayout.DEFAULT_SIZE, 321, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblInfo, javax.swing.GroupLayout.DEFAULT_SIZE, 24, Short.MAX_VALUE)
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(panelFullAPICommands, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(btnConnect, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(23, 23, 23)
                .addComponent(btnConnect)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(panelFullAPICommands, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(22, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void connectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnConnectActionPerformed

    	try {

    		ssoToken =  SessionServiceUtil.loginToCCT(serverDetails, user, password, domain, serverPort);
      	
    		List<Terminal> terminals = SessionServiceUtil.getTerminals(ssoToken);
    		for (Terminal t : terminals) {
    			if (terminal == null) {
    				terminal = t;
    			}
    			cboTerminals.addItem(t.getTerminalName());
    		}
         
    	
	    	List<Address> addresses = SessionServiceUtil.getAddresses(ssoToken);
	    	for (Address a : addresses) {
	    		if (srcAddress == null) {
	    			srcAddress = a;
	    		}
	    		cboAddresses.addItem(a.getAddressName());
	    	}
    	
	    	updateInfo("Session started : " + ssoToken.getToken());

         
//          	SubscribeUtil.publishNotificationConsumer();
//          	updateInfo("Notification Consumer Published");
          
          	//Subscription Reference needs to be kept for unsubscribe operation
          	EndpointReferenceType subscriptionRef = SubscribeUtil.subscribe(ssoToken, serverDetails, serverPort);
          	updateInfo("Subscribed");
          
          
        } catch (Exception ex) {
        	ex.printStackTrace();
            updateInfo("Error : " + ex.getMessage());
        }

    }//GEN-LAST:event_btnConnectActionPerformed

 
    	
    
    private void loginActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLoginActionPerformed
    	try {
            String agentId = txtAgentID.getText().trim();

            updateInfo("Logging-in agent : " + agentId);
            
            SessionServiceUtil.loginAgent(ssoToken, agentId, terminal, password);
            updateInfo("Logged in agent : " + agentId);
            btnLogin.setEnabled(false);
            txtAgentID.setEnabled(false);
        
        } catch (Exception ex) {
        	ex.printStackTrace();
        	updateInfo("Error : " + ex.getMessage());
        }
    } 

    

    private void updateInfo(String info) {
    	if (info.startsWith("Error")) {
    		  lblInfo.setText(info);
    	} else {
    	   lblInfo.setText("Server : " + serverDetails + " \n" + info);
    	}
    	   
		
	}

	private void createContactActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCreateActionPerformed
        try {
			String destAddressName = txtDestAddress.getText().trim();
			updateInfo("Creating Contact to " + destAddressName);
			Contact contact = SessionServiceUtil.createContact(ssoToken, terminal, srcAddress, destAddressName);
            updateInfo("Contact ID " + contact.getContactId());
            
            btnCreate.setEnabled(false);
            txtDestAddress.setEnabled(false);
            
        } catch (Exception e) {
        	e.printStackTrace();
        	updateInfo("Error : " + e.getMessage());
        }
	}
	
	private void logoutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCreateActionPerformed
        try {
        	
        } catch (Exception e) {
        	e.printStackTrace();
        	updateInfo("Error : " + e.getMessage());
        }
	}
	
	private void dropActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCreateActionPerformed
        try {
        	
        } catch (Exception e) {
        	e.printStackTrace();
        	updateInfo("Error : " + e.getMessage());
        }
	}

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
    	String serverDetails = "localhost"; //Default Setting
    	String serverPort = "9180";
    	if (args.length > 0 && args[0] != null&& args[1] != null) {
    		serverDetails = args[0];
    		serverPort = args[1];
    	}
    	new UserAPIForm(serverDetails, serverPort).setVisible(true);

    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnConnect;
    private javax.swing.JButton btnCreate;
    private javax.swing.JButton btnLogin;
    private javax.swing.JComboBox cboAddresses;
    private javax.swing.JComboBox cboTerminals;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel lblAddress;
    private javax.swing.JLabel lblAgentID;
    private javax.swing.JLabel lblDestAddress;
    private javax.swing.JLabel lblInfo;
    private javax.swing.JLabel lblTerminal;
    private javax.swing.JPanel panelFullAPICommands;
    private javax.swing.JTextField txtAgentID;
    private javax.swing.JTextField txtDestAddress;
    // End of variables declaration//GEN-END:variables

}
