package sample.soa.cct;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import com.nortel.soa.oi.cct.sessionservice.LoginAgentToStateException;
import com.nortel.soa.oi.cct.sessionservice.SOAOICCT;
import com.nortel.soa.oi.cct.sessionservice.SessionService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AuthenticationLevel;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.sessionservice.AddressList;
import com.nortel.soa.oi.cct.types.sessionservice.ContactResponse;
import com.nortel.soa.oi.cct.types.sessionservice.CreateContactRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetAddressesRequest;
import com.nortel.soa.oi.cct.types.sessionservice.GetTerminalsRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogInToCCTServerRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LogInToCCTServerResponse;
import com.nortel.soa.oi.cct.types.sessionservice.LoginAgentRequest;
import com.nortel.soa.oi.cct.types.sessionservice.LoginAgentToStateRequest;
import com.nortel.soa.oi.cct.types.sessionservice.TerminalList;

public class SessionServiceUtil {
	
	private static SessionService  sessionService;
	

	/* 
	 * Gets a connection to the SessionService service 
	 */
	public static SessionService getSessionService(String serverDetails, String serverPort) throws Exception {
        if (sessionService == null) {
			try {
	        	 String sslocation = "http://" + serverDetails +  ":" + serverPort + "/SOAOICCT/services/SessionService?wsdl";
	             URL url = new URL(sslocation);
	             sessionService = new SOAOICCT(url).getSessionService();  
	        } catch (Exception e) {
	        	e.printStackTrace();
	        	throw e;
	        }
        }
        return sessionService;
    }
	
	
	/*
	 * Login the user to the server and return the sso token that identifies the session
	 * This sso token is required for all other requests to the service
	 */
	public static SsoToken loginToCCT(String serverDetails, 
									  String user, 
									  String password, 
									  String domain, 
									  String serverPort) throws Exception {
		getSessionService(serverDetails, serverPort);
		
		LogInToCCTServerRequest loginRequest = new LogInToCCTServerRequest();
	    loginRequest.setAuthenticationLevel(new AuthenticationLevel());
	    loginRequest.getAuthenticationLevel().setDomain(domain);
	    loginRequest.getAuthenticationLevel().setPassword(password);
	    loginRequest.getAuthenticationLevel().setUsername(user);
	     
	      try {
	          LogInToCCTServerResponse  response = sessionService.logInToCCTServer(loginRequest);
	          SsoToken ssoToken = response.getSsoToken();
	          return ssoToken;
	      } catch (Exception ex) {
	        	ex.printStackTrace();
	            throw ex;
	      }
	      
	}


	public static List<Terminal> getTerminals(SsoToken ssoToken) throws Exception {
		try {
			 GetTerminalsRequest getTerminalsRequest = new GetTerminalsRequest();
	         getTerminalsRequest.setSsoToken(ssoToken);
	         TerminalList terminalsList = sessionService.getTerminals(getTerminalsRequest);
	         if (terminalsList != null) {
		          List<Terminal> terminals = terminalsList.getTerminals();
		          return terminals;
	         } else {
	        	 return new ArrayList<Terminal>();
	         }
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}
   
	
	}


	public static List<Address> getAddresses(SsoToken ssoToken) throws Exception {
		try {
			GetAddressesRequest parameters = new GetAddressesRequest();
	        parameters.setSsoToken(ssoToken);
	        AddressList addressList = sessionService.getAddresses(parameters);
 
	        if (addressList != null) {
	        	List<Address> addresses = addressList.getAddresses();
		        return addresses;
	         } else {
	        	 return new ArrayList<Address>();
	         }
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}
	}


	public static void loginAgent(SsoToken ssoToken, 
								  String agentId, 
								  Terminal terminal, 
								  String password) throws Exception {
		try {
			 LoginAgentRequest loginAgentRequest = new LoginAgentRequest();
		     loginAgentRequest.setSsoToken(ssoToken);
		     loginAgentRequest.setAgentId(agentId);
		     loginAgentRequest.setTerminal(terminal);
		     loginAgentRequest.setAgentPassword(password);

		     sessionService.loginAgent(loginAgentRequest);
			
//			LoginAgentToStateRequest loginAgentRequest = new LoginAgentToStateRequest();
//		     loginAgentRequest.setSsoToken(ssoToken);
//		     loginAgentRequest.setAgentId(agentId);
//		     loginAgentRequest.setTerminal(terminal);
//		     loginAgentRequest.setAgentPassword(password);
//		     loginAgentRequest.setInitialState(1);
//
//		     sessionService.loginAgentToState(loginAgentRequest);
			
		} catch (Exception ex) {
			
			ex.printStackTrace();
			throw ex;
		}
		 
	}

	
	

	public static Contact createContact(SsoToken ssoToken, 
										Terminal terminal,
									    Address srcAddress, 
									    String destAddressName) throws Exception {
		try {
			CreateContactRequest createContactRequest = new CreateContactRequest();
	        createContactRequest.setSsoToken(ssoToken);
	        createContactRequest.setTerminal(terminal);
	        
	        Address destAddress = new Address();
	        destAddress.setAddressName(destAddressName);
	        createContactRequest.setDstAddress(destAddress);
	        createContactRequest.setSrcAddress(srcAddress);
	        ContactResponse response = sessionService.createContact(createContactRequest);
	        return response.getContact();
	        
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}
		 
	}
	      
	
}
