package com.nortel.rc.aop;

import java.lang.reflect.Method;

import org.apache.log4j.Category;
import org.springframework.aop.ThrowsAdvice;

public class LoggingThrowsAdvice implements ThrowsAdvice
{
	private static final Category log = Category.getInstance(LoggingThrowsAdvice.class.getName());
	
    public void afterThrowing(Method method, 
                            Object[] args, 
                            Object target, 
                            Throwable subclass)
    {
    	log.error("Problem invoking: " + target.toString() +"::"+ method.getName()+
    			" Exception thrown: " + subclass.getCause());
    	
    	subclass.printStackTrace();
    }
}

