package com.nortel.rc.aop;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Category;

public class TraceLoggingInterceptor implements MethodInterceptor
{
	private static final Category log = Category.getInstance("rc.aop.TraceLoggingInterceptor");

	public Object invoke(MethodInvocation methodInvocation) throws Throwable
	{
		long startTime = System.currentTimeMillis();
		try
		{
		  Object retVal = methodInvocation.proceed();
		  return retVal;
		}
		finally
		{
			log.info("Ending: "  + methodInvocation.getMethod().getDeclaringClass() + "::" + methodInvocation.getMethod().getName()+
					" Time Taken: " + (System.currentTimeMillis() - startTime) + " msecs.");
	    }
	}
}
