package com.nortel.rc.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IConnectionServiceDAO;
import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dao.ITerminalConnectionServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.AttachedDataTO;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.StateSummaryTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;

import org.apache.log4j.Category;

public class GetContactDetailsCommand extends Command 
{
	private IContactServiceDAO contactServiceDAO;
	private IConnectionServiceDAO connectionServiceDAO;
	private ITerminalConnectionServiceDAO terminalConnectionServiceDAO;
	private ICapabilitiesFacade capabilitiesFacade;
	private static final Category log = Category.getInstance(GetContactDetailsCommand.class.getName());
   
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		String contactId = (String)params.get("contactId");
		String extContactId = (String)params.get("externalContactId");
		ContactTO contact = new ContactTO();
		contact.setContactId(contactId);
		AddressTO callingAddr = new AddressTO();
		AddressTO calledAddr = new AddressTO();
		TerminalTO callingTerm = new TerminalTO();
		AddressTO lastRedirectedAddr = new AddressTO();
		AddressTO originalDestTerm = new AddressTO();
		AttachedDataTO attachedData = null;
		String uuiData = "";
		Exception exc = null;
		boolean isExceptionThrown=false;
      
		List<String> contactTypes = new ArrayList<String>();
		
		capabilitiesFacade.getCapabilities(contact, ssoToken);
		
		try{
			callingAddr = (AddressTO)getContactServiceDAO().getCallingAddress(
					contactId, ssoToken).getObject();
		}catch(Exception e){callingAddr.setAddressName("Can't Get");}
			
		try{
			calledAddr = (AddressTO)getContactServiceDAO().getCalledAddress(
					contactId, ssoToken).getObject();
		}catch(Exception e){calledAddr.setAddressName("Can't Get");}
		
		if(contact.getCapabilities().isCanGetCallingTerminal())
		{
			try
			{
				callingTerm = (TerminalTO)getContactServiceDAO().getCallingTerminal(contactId, ssoToken).getObject();
			}catch(Exception e){callingTerm.setTerminalName("Can't Get");}
		}
		else
		{
			callingTerm.setTerminalName("Can't Get");
		}		
		
		if(contact.getCapabilities().isCanGetLastRedirectedAddress())
		{	
			try{
				lastRedirectedAddr = (AddressTO)getContactServiceDAO().getLastRedirectedAddress(contactId, ssoToken).getObject();
			}catch(Exception e){lastRedirectedAddr.setAddressName("Can't Get");}
		}
		else
		{
			lastRedirectedAddr.setAddressName("Can't Get");
		}
		
		if(contact.getCapabilities().isCanGetOriginalDestination())
		{
			try
			{
				originalDestTerm = (AddressTO)getContactServiceDAO().getOriginalDestinationAddress(
					contactId, ssoToken).getObject();
			}catch(Exception e){originalDestTerm.setAddressName("Can't Get");}
		}
		else
		{
			originalDestTerm.setAddressName("Can't Get");
		}
		
		if(contact.getCapabilities().isCanGetAttachedData())
		{
			try
			{
				attachedData = (AttachedDataTO)getContactServiceDAO().getAttachedData(
					contactId, ssoToken).getObject();
            log.info("GetContactDetailsCommand: " + attachedData);
			}catch(Exception e)
			{
				attachedData = new AttachedDataTO();
				originalDestTerm.setAddressName("Can't Get");
				isExceptionThrown = true;
				exc = e;
			}
		}
		else
		{
			attachedData = new AttachedDataTO();
			attachedData.setStringData("Can't Get");
		}
		
		if(contact.getCapabilities().isCanGetUUI())
		{
			try
			{
				uuiData = getContactServiceDAO().getUUIData(
					contactId, ssoToken).getMessage();
			}catch(Exception e){uuiData = "Can't Get";}
		}
		else
		{
			uuiData = "Can't Get";
		}
			
		try{	
			contactTypes = (List<String>)getContactServiceDAO().getContactTypes(contactId, ssoToken).getObject();
		}catch(Exception e)
		{
			System.err.println("Contact Types Exception (Contact)");
		}
		
		
		//Retrieve the current connections and terminal connections (and their names address/terminal)
		try {
			for(ConnectionTO connection: (List<ConnectionTO>)getContactServiceDAO().getConnections(contactId, ssoToken).getObject())
			{
				String connectionId = connection.getConnectionId();
				try {
					connection.setAddressName(((AddressTO)getConnectionServiceDAO().getAddress(connectionId, ssoToken).getObject()).getAddressName());
				} catch (DAOException e) {
					log.warn("The address could not be fetched for connection[" + connectionId+ "]", e);
				}
				try {
					connection.setStateSummary((StateSummaryTO)getConnectionServiceDAO().getState(connectionId, ssoToken).getObject());
				} catch (DAOException e) {
					log.warn("The state could not be fetched for connection[" + connectionId+ "]", e);
				}
				try {
					getCapabilitiesFacade().getCapabilities(connection, ssoToken);
				} catch (DAOException e) {
					log.warn("The capabilities could not be fetched for connection[" + connectionId+ "]", e);
				}
				try {
					for(TerminalConnectionTO termConn : (List<TerminalConnectionTO>)getConnectionServiceDAO().getTerminalConnections(connectionId, ssoToken).getObject())
					{
						String tcId = termConn.getTerminalConnectionId();
						try {
							termConn.setTerminalName(((TerminalTO)getTerminalConnectionServiceDAO().getTerminal(tcId, ssoToken).getObject()).getTerminalName());
						} catch (DAOException e) {
							log.warn("The terminal could not be fetched for terminalConnection[" + tcId+ "]", e);
						}
						try {
							termConn.setContactType((String)getTerminalConnectionServiceDAO().getContactType(tcId, ssoToken).getObject());
						} catch (DAOException e) {
							log.warn("The contactType could not be fetched for terminalConnection[" + tcId+ "]", e);
						}
						try {
							termConn.setStateSummary((StateSummaryTO)getTerminalConnectionServiceDAO().getState(tcId, ssoToken).getObject());
						} catch (DAOException e) {
							log.warn("The state could not be fetched for terminalConnection[" + tcId+ "]", e);
						}
						try {
							termConn.setConferenceConsult((ContactTO)getTerminalConnectionServiceDAO().getConferenceConsult(tcId, ssoToken).getObject());
						} catch (DAOException e) {
							log.warn("The conference consult could not be fetched for terminalConnection[" + tcId+ "]", e);
						}
						try {
							termConn.setTransferConsult((ContactTO)getTerminalConnectionServiceDAO().getTransferConsult(tcId, ssoToken).getObject());
						} catch (DAOException e) {
							log.warn("The transfer consult could not be fetched for terminalConnection[" + tcId+ "]", e);
						}
						try {
							getCapabilitiesFacade().getCapabilities(termConn, ssoToken);
						} catch (DAOException e) {
							log.warn("The capabilities could not be fetched for terminalConnection[" + tcId+ "]", e);
						}
						connection.addTerminalConnection(termConn);
					}
				} catch (DAOException e) {
					log.warn("The terminal connections could not be fetched for connection[" + connectionId + "]", e);
				}
				contact.addConnection(connection);
			}
		} catch (DAOException e) {
			log.warn("The connections could not be fetched for the contact["+contactId+"] ", e);
		}
		contact.setExternalContactId(extContactId);
		contact.setCalledAddress(calledAddr != null ? calledAddr.getAddressName() : null);
		contact.setCallingAddress(callingAddr != null ? callingAddr.getAddressName() : null);
		contact.setCallingTerminal(callingTerm != null ? callingTerm.getTerminalName() : null);
		contact.setLastRedirectedAddress(lastRedirectedAddr != null ? lastRedirectedAddr.getAddressName() : null);
		contact.setOriginalDestinationAddress(originalDestTerm != null ? originalDestTerm.getAddressName() : null);
		contact.setAttachedData(attachedData);
		contact.setUuiData(uuiData);
		contact.setContactTypes(contactTypes);
    	
		getRefClient().supplementContactInfo(contact);
		if (isExceptionThrown)
		{
			throw new Exception(exc);
		}   
	}
	
	/**
	 * @return the contactServiceDAO
	 */
	public IContactServiceDAO getContactServiceDAO() {
		return contactServiceDAO;
	}

	/**
	 * @param contactServiceDAO the contactServiceDAO to set
	 */
	public void setContactServiceDAO(IContactServiceDAO contactServiceDAO) {
		this.contactServiceDAO = contactServiceDAO;
	}

	/**
	 * @return the capabilitiesFacade
	 */
	public ICapabilitiesFacade getCapabilitiesFacade() {
		return capabilitiesFacade;
	}

	/**
	 * @param capabilitiesFacade the capabilitiesFacade to set
	 */
	public void setCapabilitiesFacade(ICapabilitiesFacade capabilitiesFacade) {
		this.capabilitiesFacade = capabilitiesFacade;
	}

	/**
	 * @return the connectionServiceDAO
	 */
	public IConnectionServiceDAO getConnectionServiceDAO() {
		return connectionServiceDAO;
	}

	/**
	 * @param connectionServiceDAO the connectionServiceDAO to set
	 */
	public void setConnectionServiceDAO(IConnectionServiceDAO connectionServiceDAO) {
		this.connectionServiceDAO = connectionServiceDAO;
	}

	/**
	 * @return the terminalConnectionServiceDAO
	 */
	public ITerminalConnectionServiceDAO getTerminalConnectionServiceDAO() {
		return terminalConnectionServiceDAO;
	}

	/**
	 * @param terminalConnectionServiceDAO the terminalConnectionServiceDAO to set
	 */
	public void setTerminalConnectionServiceDAO(
			ITerminalConnectionServiceDAO terminalConnectionServiceDAO) {
		this.terminalConnectionServiceDAO = terminalConnectionServiceDAO;
	}
   
}
