package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IAddressServiceDAO;
import com.nortel.rc.dto.AddressTO;

public class SetForwardingAddressCommand extends Command 
{
	private IAddressServiceDAO addressServiceDAO;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		AddressTO address = (AddressTO)params.get("address");
			
		getAddressServiceDAO().setForwarding(address, ssoToken);
	}

	/**
	 * @return the addressServiceDAO
	 */
	public IAddressServiceDAO getAddressServiceDAO() {
		return addressServiceDAO;
	}

	/**
	 * @param addressServiceDAO the addressServiceDAO to set
	 */
	public void setAddressServiceDAO(IAddressServiceDAO addressServiceDAO) {
		this.addressServiceDAO = addressServiceDAO;
	}
}
