package com.nortel.rc.dto;

import java.util.ArrayList;
import java.util.List;

public class AgentTO
{
	public static final String LOGGED_IN = "Logged In";	
	public static final String NOT_LOGGED_IN = "Not Logged In";
	public static final String READY_STATE = "Ready";	
	public static final String NOT_READY_STATE = "Not Ready";

	private String agentUsername;
	private String agentLoginId;
	private String agentType;
	private String password;
	private boolean loggedIn = false;
	private boolean ready = false;
	private String notReadyReasonCode;
	private TerminalTO staticVoiceTerminal;
	private AgentTO supervisor;
	private AgentCapabilitiesTO agentCapabilities;
	private List<String> contactTypes = new ArrayList<String>();

	/**
	 * @return the agentUsername
	 */
	public String getAgentUsername() {
		return agentUsername;
	}


	/**
	 * @param agentUsername the agentUsername to set
	 */
	public void setAgentUsername(String agentUsername) {
		this.agentUsername = agentUsername;
	}


	/**
	 * @return the agentLoginId
	 */
	public String getAgentLoginId() {
		return agentLoginId;
	}


	/**
	 * @param agentLoginId the agentLoginId to set
	 */
	public void setAgentLoginId(String agentLoginId) {
		this.agentLoginId = agentLoginId;
	}


	/**
	 * @return the agentCapabilities
	 */
	public AgentCapabilitiesTO getAgentCapabilities() {
		return agentCapabilities;
	}


	/**
	 * @param agentCapabilities the agentCapabilities to set
	 */
	public void setAgentCapabilities(AgentCapabilitiesTO agentCapabilities) {
		this.agentCapabilities = agentCapabilities;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final AgentTO other = (AgentTO) obj;
		if (agentUsername == null) {
			if (other.agentUsername != null)
				return false;
		} else if (!agentUsername.equals(other.agentUsername))
			return false;
		return true;
	}


	/**
	 * @return the loggedIn
	 */
	public boolean isLoggedIn() {
		return loggedIn;
	}


	/**
	 * @param loggedIn the loggedIn to set
	 */
	public void setLoggedIn(boolean loggedIn) {
		this.loggedIn = loggedIn;
	}


	/**
	 * @return the ready
	 */
	public boolean isReady() {
		return ready;
	}


	/**
	 * @param ready the ready to set
	 */
	public void setReady(boolean ready) {
		this.ready = ready;
	}
	
	public String getLoginStatus()
	{
		return loggedIn ? LOGGED_IN : NOT_LOGGED_IN;		
	}
	
	public String getReadyStatus()
	{
		if(ready)
		{
			return READY_STATE;
		}
		else
		{
			if(notReadyReasonCode == null)
			{
				return NOT_READY_STATE;
			}
			else
			{
				return notReadyReasonCode;
			}
		}
	}


	/**
	 * @return the password
	 */
	public String getPassword() {
		return password;
	}


	/**
	 * @param password the password to set
	 */
	public void setPassword(String password) {
		this.password = password;
	}


	/**
	 * @return the contactTypes
	 */
	public List<String> getContactTypes() {
		return contactTypes;
	}


	/**
	 * @param contactTypes the contactTypes to set
	 */
	public void setContactTypes(List<String> contactTypes) {
		this.contactTypes = contactTypes;
	}


	/**
	 * @return the notReadyReasonCode
	 */
	public String getNotReadyReasonCode() {
		if(isReady())
			return "n/a";
		return notReadyReasonCode;
	}


	/**
	 * @param notReadyReasonCode the notReadyReasonCode to set
	 */
	public void setNotReadyReasonCode(String notReadyReasonCode) {
		this.notReadyReasonCode = notReadyReasonCode;
	}


	/**
	 * @return the staticVoiceTerminal
	 */
	public TerminalTO getStaticVoiceTerminal() {
		return staticVoiceTerminal;
	}


	/**
	 * @param staticVoiceTerminal the staticVoiceTerminal to set
	 */
	public void setStaticVoiceTerminal(TerminalTO staticVoiceTerminal) {
		this.staticVoiceTerminal = staticVoiceTerminal;
	}


	/**
	 * @return the agentType
	 */
	public String getAgentType() {
		return agentType;
	}


	/**
	 * @param agentType the agentType to set
	 */
	public void setAgentType(String agentType) {
		this.agentType = agentType;
	}


	/**
	 * @return the supervisor
	 */
	public AgentTO getSupervisor() {
		return supervisor;
	}


	/**
	 * @param supervisor the supervisor to set
	 */
	public void setSupervisor(AgentTO supervisor) {
		this.supervisor = supervisor;
	}
}
