package com.nortel.rc.dto;

import java.util.ArrayList;

public class AttachedDataTO {

	public enum AttachedDataType {
		STRING,
		BINARY,
		KVP;
	}
	
	private AttachedDataType type;
	private String stringData;
	private byte[] binaryData;
	private KeyValuePairTO[] keyValueData;
	/**
	 * @return the stringData
	 */
	public String getStringData() {
		return stringData;
	}
	/**
	 * @param stringData the stringData to set
	 */
	public void setStringData(String stringData) {
		this.stringData = stringData;
	}
	/**
	 * @return the binaryData
	 */
	public byte[] getBinaryData() {
		return binaryData;
	}
	/**
	 * @return the hex String representation of the binaryData
	 */
	public String getBinaryDataString() {
		return getBinaryDisplay();
	}
	/**
	 * @param binaryData the binaryData to set 
	 */
	public void setBinaryData(byte[] binaryData) {
		this.binaryData = binaryData;
	}
	/**
	 * @param hexData to be converted and set to binaryData 
	 */
	public void setBinaryData(String hexData) throws NumberFormatException {
		this.binaryData = hexToBinary(hexData);
	}
	/**
	 * @return the keyValueData
	 */
	public KeyValuePairTO[] getKeyValueData() {
		return keyValueData;
	}
	/**
	 * @param keyValueData the keyValueData to set
	 */
	public void setKeyValueData(KeyValuePairTO[] keyValueData) {
		this.keyValueData = keyValueData;
	}
	/**
	 * @return the type
	 */
	public AttachedDataType getType() {
		return type;
	}
	/**
	 * @param type the type to set
	 */
	public void setType(AttachedDataType type) {
		this.type = type;
	}
	
	public String toString()
	{
		if(stringData != null)
		{
			return stringData;
		}
		else if(binaryData != null)
		{
			return getBinaryDisplay();
		}
		else if(keyValueData != null)
		{
			return getKVPDisplay();
		}
		return "";
	}
	
	private byte[] hexToBinary(String hex) throws NumberFormatException
	{
		ArrayList<String> bytes = new ArrayList<String>();
		
		for (int i = 0; i < hex.length();)
		{
			int delim_pos = hex.indexOf(' ', i);
			if (delim_pos == -1)
				delim_pos = hex.length();

			int len = delim_pos - i;
			if (len > 2)
				len = 2;

			String hex_byte = hex.substring(i, i+len);
			System.out.println("hex_byte: "+hex_byte);
			i += len;
			
			bytes.add(""+Integer.parseInt(hex_byte, 16));
			System.out.println("Added (String): "+Integer.parseInt(hex_byte, 16));

			System.out.println("space: "+hex.length()+" - "+i);
			if (i < hex.length()) {
				String space = hex.substring(i, i+1);
				if (space.equals(" "))
					i++;
			}
		}
		//Now convert ArrayList of Strings (each representing a byte)
		//to an array of bytes.
		byte[] byteArray = new byte[bytes.size()];
		for (int i=0; i<bytes.size(); i++)
		{
			byteArray[i] = new Byte((String)bytes.get(i)).byteValue();
			System.out.println("Adding (byte): "+byteArray[i]);
		}
		return byteArray;
	}
	
	private String getBinaryDisplay()
	{	
		StringBuffer sb = new StringBuffer();
		for(byte b : binaryData)
		{
			String hStr = Integer.toHexString(Integer.parseInt(b+""));
			if(hStr.length() == 1)
			{
				sb.append("0"+hStr);
			}
			else
			{
				sb.append(hStr);
			}
			sb.append(" ");
		}
		return sb.toString().trim();		
	}
	
	private String getKVPDisplay()
	{	
		StringBuffer sb = new StringBuffer();
		sb.append("[");
		for(KeyValuePairTO kvp : keyValueData)
		{
			sb.append("(")
			.append(kvp.getKey())
			.append(",")
			.append(kvp.getValue())
			.append("(");
		}
		sb.append("]");
		return sb.toString();		
	}
}
