package com.nortel.rc.dto;

import java.util.ArrayList;
import java.util.List;

public class ConnectionCapabilitiesTO implements CapabilitiesTO{
	
	private boolean canAccept = false;
	private boolean canDisconnect = false;
	private boolean canAlert = false;
	private boolean canPark = false;
	private boolean canRedirect = false;
	private boolean canReject = false;
	
	private List<CapabilityTO> capabilityList;
	
	public List<CapabilityTO> getCapabilityList()
	{
		capabilityList = new ArrayList<CapabilityTO>();
		CapabilityTO capability = new CapabilityTO("Accept", isCanAccept());
		capabilityList.add(capability);
		capability = new CapabilityTO("Disconnect", isCanDisconnect());
		capabilityList.add(capability);
		capability = new CapabilityTO("Alert", isCanAlert());
		capabilityList.add(capability);
		capability = new CapabilityTO("Park", isCanPark());
		capabilityList.add(capability);
		capability = new CapabilityTO("Redirect", isCanRedirect());
		capabilityList.add(capability);
		capability = new CapabilityTO("Reject", isCanReject());
		capabilityList.add(capability);
		return capabilityList;
	}

	/**
	 * @return the canAccept
	 */
	public boolean isCanAccept() {
		return canAccept;
	}

	/**
	 * @param canAccept the canAccept to set
	 */
	public void setCanAccept(boolean canAccept) {
		this.canAccept = canAccept;
	}

	/**
	 * @return the canDisconnect
	 */
	public boolean isCanDisconnect() {
		return canDisconnect;
	}

	/**
	 * @param canDisconnect the canDisconnect to set
	 */
	public void setCanDisconnect(boolean canDisconnect) {
		this.canDisconnect = canDisconnect;
	}

	/**
	 * @return the canAlert
	 */
	public boolean isCanAlert() {
		return canAlert;
	}

	/**
	 * @param canAlert the canAlert to set
	 */
	public void setCanAlert(boolean canAlert) {
		this.canAlert = canAlert;
	}

	/**
	 * @return the canPark
	 */
	public boolean isCanPark() {
		return canPark;
	}

	/**
	 * @param canPark the canPark to set
	 */
	public void setCanPark(boolean canPark) {
		this.canPark = canPark;
	}

	/**
	 * @return the canRedirect
	 */
	public boolean isCanRedirect() {
		return canRedirect;
	}

	/**
	 * @param canRedirect the canRedirect to set
	 */
	public void setCanRedirect(boolean canRedirect) {
		this.canRedirect = canRedirect;
	}

	/**
	 * @return the canReject
	 */
	public boolean isCanReject() {
		return canReject;
	}

	/**
	 * @param canReject the canReject to set
	 */
	public void setCanReject(boolean canReject) {
		this.canReject = canReject;
	}	
}
