package com.nortel.rc.dto;

import org.apache.commons.lang.StringUtils;

public class StateEventTO extends EventTO{

	private String terminal = "";
	private String address = "";
	private String defaultTreatment = "";
	private String localState = "";
	private String prevLocalState = "";
	private String remoteState = "";
	private String prevRemoteState = "";
	private String reason = "";
	private String type = "";
	private String contactId = "";
	private String externalContactId = "";
	private ConnectionTO connection = null;
	private TerminalConnectionTO terminalConnection = null;
	private String calling = "";
	private String called = "";
	private Boolean transferInitiated = false; 
	private Boolean conferenceInitiated = false;
	private String notifiedAddress = "";
	private Boolean isRemote = false;

	/**
	 * @return the terminal
	 */
	public String getTerminal() {
		return terminal;
	}

	/**
	 * @param terminal
	 *            the terminal to set
	 */
	public void setTerminal(String terminal) {
		this.terminal = terminal;
	}

	/**
	 * @return the address
	 */
	public String getAddress() {
		return address;
	}

	/**
	 * @param address
	 *            the address to set
	 */
	public void setAddress(String address) {
		this.address = address;
	}
	
	/**
	 * @return the notifiedAddress
	 */
	public String getNotifiedAddress() {
		return notifiedAddress;
	}
	
	/**
	 * @param adr
	 *            the notifiedAddress to set
	 */
	public void setNotifiedAddress(String adr) {
		this.notifiedAddress = adr;
	}

	/**
	 * @return the localState
	 */
	public String getLocalState() {
		return localState;
	}

	/**
	 * @param localState
	 *            the localState to set
	 */
	public void setLocalState(String localState) {
		this.localState = localState;
	}

	/**
	 * @return the remoteState
	 */
	public String getRemoteState() {
		return remoteState;
	}

	/**
	 * @param remoteState
	 *            the remoteState to set
	 */
	public void setRemoteState(String remoteState) {
		this.remoteState = remoteState;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the contactId
	 */
	public String getContactId() {
		return contactId;
	}

	/**
	 * @param contactId
	 *            the contactId to set
	 */
	public void setContactId(String contactId) {
		this.contactId = contactId;
	}

	/**
	 * @return the calling
	 */
	public String getCalling() {
		return calling;
	}

	/**
	 * @param calling
	 *            the calling to set
	 */
	public void setCalling(String calling) {
		this.calling = calling;
	}

	/**
	 * @return the called
	 */
	public String getCalled() {
		return called;
	}

	/**
	 * @param called
	 *            the called to set
	 */
	public void setCalled(String called) {
		this.called = called;
	}

	/**
	 * @return the connection
	 */
	public ConnectionTO getConnection() {
		return connection;
	}

	/**
	 * @param connection the connection to set
	 */
	public void setConnection(ConnectionTO connection) {
		this.connection = connection;
	}

	/**
	 * @return the terminalConnection
	 */
	public TerminalConnectionTO getTerminalConnection() {
		return terminalConnection;
	}
	
	public TerminalConnectionTO getTerminalConnection(ContactTO contact) {
		TerminalConnectionTO tc = null;
		String terminal = getTerminal();
		String address = getAddress();
		if (contact != null) {
			if(StringUtils.isNotEmpty(terminal) && StringUtils.isNotEmpty(address))
			{
				tc = contact.getTerminalConnection(terminal, address);
			}
		}
		return tc;
	}

	/**
	 * @param terminalConnection the terminalConnection to set
	 */
	public void setTerminalConnection(TerminalConnectionTO terminalConnection) {
		this.terminalConnection = terminalConnection;
	}

	/**
	 * @return the prevLocalState
	 */
	public String getPrevLocalState() {
		return prevLocalState;
	}

	/**
	 * @param prevLocalState the prevLocalState to set
	 */
	public void setPrevLocalState(String prevLocalState) {
		this.prevLocalState = prevLocalState;
	}

	/**
	 * @return the prevRemoteState
	 */
	public String getPrevRemoteState() {
		return prevRemoteState;
	}

	/**
	 * @param prevRemoteState the prevRemoteState to set
	 */
	public void setPrevRemoteState(String prevRemoteState) {
		this.prevRemoteState = prevRemoteState;
	}

	/**
	 * @return the reason
	 */
	public String getReason() {
		return reason;
	}

	/**
	 * @param reason the reason to set
	 */
	public void setReason(String reason) {
		this.reason = reason;
	}

	/**
	 * @return the externalContactId
	 */
	public String getExternalContactId() {
		return externalContactId;
	}

	/**
	 * @param externalContactId the externalContactId to set
	 */
	public void setExternalContactId(String externalContactId) {
		this.externalContactId = externalContactId;
	}

	/**
	 * @return the defaultTreatment
	 */
	public String getDefaultTreatment() {
		return defaultTreatment;
	}

	/**
	 * @param defaultTreatment the defaultTreatment to set
	 */
	public void setDefaultTreatment(String defaultTreatment) {
		this.defaultTreatment = defaultTreatment;
	}

	/**
	 * @return true if for this contact a transfer has been initiated
	 */
	public Boolean isTransferInitiated() {
		return transferInitiated;
	}

	/**
	 * Sets the transferInitiated flag for this contact
	 * @param transferInitiated the new value 
	 */
	public void setTransferInitiated(Boolean transferInitiated) {
		this.transferInitiated = transferInitiated;
	}

	/**
	 * @return true if for this contact a conference has been initiated 
	 */
	public Boolean isConferenceInitiated() {
		return conferenceInitiated;
	}

	/**
	 * Sets the conferenceInitiated flag for this contact
	 * @param conferenceInitiated the new value
	 */
	public void setConferenceInitiated(Boolean conferenceInitiated) {
		this.conferenceInitiated = conferenceInitiated;
	}
	
	/**
	 * Sets the isRemote flag
	 * @param isRemote the boolean value to set
	 */
	public void setRemote(Boolean isRemote) {
		this.isRemote = isRemote;
	}
	
	/**
	 * @return true 
	 * if for the remote terminal\address, false otherwise
	 */
	public boolean isRemote() {
		return this.isRemote;
	}
	
}
