//////////////////////////////////////////////////////////////////////////////
// HASwitchOverHandler.java
//
// Avaya Inc. - Proprietary (Restricted)
// Solely for authorized persons having a need to know
// pursuant to Company instructions.
//
// Copyright  2008-2013 Avaya Inc. All rights reserved.
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
// The copyright notice above does not evidence any actual
// or intended publication of such source code.
//////////////////////////////////////////////////////////////////////////////
package com.nortel.rc.event;

import java.net.InetAddress;
import java.net.UnknownHostException;

import javax.xml.ws.Endpoint;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.command.SwitchOverHandlerCommand;
import com.nortel.soa.oi.cct.haswitchoverconsumer.HASwitchOverConsumer;
import com.nortel.soa.oi.cct.haswitchoverconsumer.HASwitchOverEvent;

@javax.jws.WebService(
		name = "HASwitchOverConsumer",
		serviceName = "HASwitchOverConsumerService",
		portName = "HASwitchOverConsumerPort",
		targetNamespace = "http://www.nortel.com/soa/oi/cct/HASwitchOverConsumer",
		endpointInterface = "com.nortel.soa.oi.cct.haswitchoverconsumer.HASwitchOverConsumer")
public class HASwitchOverHandler implements IHASwitchOverHandler,HASwitchOverConsumer {

	private static Logger logger = Logger.getLogger("rc.event.HASwitchOverHandler");

	public static String consumerAddress = null;
	
	private SwitchOverHandlerCommand switchOverHandlerCommand;

	public HASwitchOverHandler(String port)
	{
		String hostname = null;
		try {
			InetAddress addr = InetAddress.getLocalHost();
			hostname = addr.getHostAddress();
		} catch (UnknownHostException e) {
			hostname = "localhost";
		}
		String passedPort = System.getProperty("notification.port");
		String portToUse = passedPort == null || passedPort.equals("") ? ""+NotificationHandler.findAvailablePort(port) : passedPort;

		consumerAddress = "http://"+hostname+":"+portToUse+"/SOAOICCT/services/HASwitchOverConsumer";

		logger.log(Level.INFO, "Publishing HASwitchOverHandler: "+consumerAddress);
		Endpoint.publish(consumerAddress, this);

	}

	public synchronized void notifyHASwitchOver(HASwitchOverEvent haSwitchOverEvent) {
		try {
			logger.log(Level.INFO, "notifyHASwitchOver triggered");
			getswitchOverHandlerCommand().execute(null);
		} catch (Exception e) {
			StackTraceElement[] stack = e.getStackTrace();
			StringBuilder strb = new StringBuilder("notifyHASwitchOver");
			strb.append(e.getCause());strb.append("\n");
			strb.append(e.getMessage());strb.append("\n");
			for(StackTraceElement s: stack){
				strb.append(s.toString());strb.append("\n");
			}
			logger.log(Level.INFO, strb.toString());
		}
		
	}

	public SwitchOverHandlerCommand getswitchOverHandlerCommand() {
		return switchOverHandlerCommand;
	}

	public void setswitchOverHandlerCommand(SwitchOverHandlerCommand switchOverHandlerCommand) {
		this.switchOverHandlerCommand = switchOverHandlerCommand;
	}
}
