package com.nortel.rc.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.PropertyConfigurator;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.core.io.ClassPathResource;

import com.nortel.rc.command.Command;
import com.nortel.rc.event.IHASwitchOverHandler;
import com.nortel.rc.event.INotificationHandler;
import com.nortel.rc.exception.DAOException;
import com.nortel.rc.gui.SOARefClient;

public class RequestHandler implements MessageSourceAware
 {
	public RequestHandler(String loggingProps)
	{
		Properties props = new Properties();
		InputStream in = null;
		try
		{
			in = new ClassPathResource(loggingProps).getInputStream();
			props.load(in);
		}
		catch(IOException ioe)
		{
			ioe.printStackTrace();
		}
		finally
		{
			if (in!=null){
				try {
					in.close();
				} catch (IOException e) {
				}
			}			
		}
		PropertyConfigurator.configure(props);
	}
	
	@SuppressWarnings("unused")
	private INotificationHandler notificationHandler;
	private IHASwitchOverHandler haSwitchOverHandler;
	private Map<String, Command> commands;
	public MessageSource messageSource;
	
	public boolean handle(String cmd, Map<String, Object> params)
	{	
		Command comm = null;
		boolean isExceptionThrown = false;
		try
		{
			comm = getCommand(cmd);
		}
		catch(Exception e)
		{
			SOARefClient.reportError(cmd, e.getMessage());
			return true;
		}
		
		try
		{
			comm.execute(params);
		}
		catch(DAOException de)
		{
	    	if(de.getCause() != null && de.getCause().getClass().toString().contains("javax.xml.ws.soap.SOAPFaultException"))
	    	{
	    		SOARefClient.reportError(cmd, "Your session token has expired. Connect to CCT again to receive a new token");
	    	}
	    	else
	    	{
	    		SOARefClient.reportError(cmd, de.getMessage());
	    	}
	    	isExceptionThrown = true;
		}
		catch(Exception e)
		{
			SOARefClient.reportError(cmd, e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
			isExceptionThrown = true;
		}
		return isExceptionThrown;
	}
	
	private Command getCommand(String cmd) throws Exception
	{
		if(commands.containsKey(cmd))
		{
			return (Command)commands.get(cmd);
		}
		else
		{
			throw new NullPointerException("Problem locating Command to execute "+cmd);
		}
	}
	
	/**
	 * @param commands the commands to set
	 */
	public void setCommands(Map<String, Command> commands) {
		this.commands = commands;
	}

	/**
	 * @param notificationHandler the notificationHandler to set
	 */
	public void setNotificationHandler(INotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}
	
	/**
	 * @return the notificationHandler
	 */
	public INotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	/**
	 * @return the messageSource
	 */
	public MessageSource getMessageSource() {
		return messageSource;
	}

	/**
	 * @param messageSource the messageSource to set
	 */
	public void setMessageSource(MessageSource messageSource) {
		this.messageSource = messageSource;
	}
	
	public IHASwitchOverHandler getHaSwitchOverHandler() {
		return haSwitchOverHandler;
	} 


	public void setHaSwitchOverHandler(IHASwitchOverHandler haSwitchOverHandler) {
		this.haSwitchOverHandler = haSwitchOverHandler;
	}
}