package com.nortel.rc.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.IAddressServiceDAO;
import com.nortel.rc.dao.IAgentTerminalServiceDAO;
import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IConnectionServiceDAO;
import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dao.INotificationDAO;
import com.nortel.rc.dao.IRoutePointAddressServiceDAO;
import com.nortel.rc.dao.ITerminalConnectionServiceDAO;
import com.nortel.rc.dao.ITerminalServiceDAO;
import com.nortel.rc.dao.IUserServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.StateEventTO;
import com.nortel.rc.dto.StateSummaryTO;
import com.nortel.rc.dto.TerminalCapabilitiesTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.dto.UserContextDO;

public class CCTLoginCommand extends Command 
{
	private IContactDAO contactDAO;
	private INotificationDAO notificationDAO;
	private ICapabilitiesFacade capabilitiesFacade;
	private IAgentTerminalServiceDAO agentTerminalServiceDAO;
	private ITerminalServiceDAO terminalServiceDAO;
	private IContactServiceDAO contactServiceDAO;
	private IAddressServiceDAO addressServiceDAO;
	private IRoutePointAddressServiceDAO routePointAddressServiceDAO;
	private IConnectionServiceDAO connectionServiceDAO;
	private ITerminalConnectionServiceDAO terminalConnectionServiceDAO;
	private IUserServiceDAO userServiceDAO;
	
	UserContextDO userContext = new UserContextDO();;
	List<TerminalTO> terminals = null;
	List<AddressTO> unmappedAddresses = null;
	List<StateEventTO> currentStateEvents = new ArrayList<StateEventTO>();
	
	public void execute(Map<String, Object> params) throws Exception
	{
		CallResult cr = getContactDAO().cctLogin((String)params.get("cctUname"), (String)params.get("cctPwd"), (String)params.get("cctDom"));
		setSsoToken(cr.getMessage());
		
		//Subscribe for Notifications in a separate thread
		Thread thread = new Thread(new SubscribeHandler());
		thread.start();
		
		//Retrieve the resources for this CCTUser
		buildUserContext();
		
		//Add and in-progress contact to the context
		retrieveInProgressContactInfo();
		
		//Initialize the UI with the userContext
		getRefClient().initUserContext(userContext);
		
		//Add the in-progress contacts like a notification would
		for(StateEventTO stateEvent : currentStateEvents)
		{
			getRefClient().updateContactsInfo(stateEvent);
		}
	}
	
	private class SubscribeHandler implements Runnable
	{
		public void run()
		{
			//Subscribe for Notifications
			try{
				getNotificationDAO().subscribe(null, null, Command.ssoToken);
				getUserServiceDAO().startHASwitchEventListener(Command.ssoToken);
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	private UserContextDO buildUserContext() throws Exception
	{
		userContext.reset();
		//Build Terminals Addresses and the information about them (Logged In, Ready, DND, FWD)
		terminals = getContactDAO().getUserTerminals(ssoToken);
		unmappedAddresses = getContactDAO().getUserAddresses(ssoToken);
		
		if(terminals != null)
		{
			CallResult cr;
			for(TerminalTO terminal : terminals)
			{
				for(AddressTO address : getContactDAO().getTerminalAddresses(terminal, ssoToken))
				{
					//Assign the capabilities to the address
					getCapabilitiesFacade().getCapabilities(address, ssoToken);					
					terminal.addAddress(address);
					
					//This address is mapped - remove from overall addresses
					unmappedAddresses.remove(address);
				}
				getCapabilitiesFacade().getCapabilities(terminal, ssoToken);
				
				//Get Logged In, Ready State, DND, Forwarded for Terminal
				cr = getAgentTerminalServiceDAO().isLoggedIn(terminal, ssoToken);
				terminal.setAgentLoggedIn(((Boolean)cr.getObject()).booleanValue());
				cr = getAgentTerminalServiceDAO().isReady(terminal, ssoToken);
				terminal.setTerminalReady(((Boolean)cr.getObject()).booleanValue());
				
				if (terminal.isAgentLoggedIn()){
					cr = getAgentTerminalServiceDAO().getLoginId(terminal, ssoToken);
					terminal.setLoginId(cr.getObject().toString());
				}
				
				TerminalCapabilitiesTO capabilities = terminal.getTerminalCapabilities();
				if (capabilities!= null && capabilities.isCanForward()) {
					cr = getTerminalServiceDAO().isForwarded(terminal, ssoToken);
					terminal.setForwarding(((Boolean)cr.getObject()).booleanValue());					
				}

				//May not have capability to getDoNotDisturb
				//e.g. Default Terminals when Blended Agent logs in				
				if (capabilities!= null && capabilities.isCanDoNotDisturb()) {
					cr = getTerminalServiceDAO().getDoNotDisturb(terminal, ssoToken);
					terminal.setDoNotDisturb(((Boolean)cr.getObject()).booleanValue());
				}
				
				cr = getTerminalServiceDAO().getContactTypes(terminal, ssoToken);
				terminal.setContactTypes(((List<String>)cr.getObject()));
//				if(terminal.getTerminalCapabilities().is)
//				{
//					cr = agentTerminalServiceDAO.getActivityCode(terminal, ssoToken);
//					terminal.setTerminalActivityCode(cr.getMessage());
//				}
			}
		}
		
		//Get RoutePoint info and assign the capabilities for each unmapped address
		for(AddressTO address : unmappedAddresses)
		{			
			getCapabilitiesFacade().getCapabilities(address, ssoToken);
			CallResult cr = getRoutePointAddressServiceDAO().isControlled(address, ssoToken);
			address.setControlled(((Boolean)cr.getObject()).booleanValue());
		}
		
		userContext.setTerminals(terminals);
		if(!unmappedAddresses.isEmpty())
		{
			userContext.setUnmappedAddresses(unmappedAddresses);
		}
		
		return userContext;
	}
	
	@SuppressWarnings("unchecked")
	//Find contacts based on assigned addresses
	private void retrieveInProgressContactInfo() throws Exception
	{	
		currentStateEvents.clear();
		if(terminals != null)
		{
			for(TerminalTO terminal : terminals)
			{
				//Check each address to see if it's on a contact
				for(AddressTO address : terminal.getAddresses())
				{
					//Check for connections
					List<ConnectionTO> connections = (List<ConnectionTO>)
						getAddressServiceDAO().getConnections(address, ssoToken).getObject();
					for(ConnectionTO conn : connections)
					{
						conn.setAddressName(address.getAddressName());
						
						//Get the terminal connections for current connection
						List<TerminalConnectionTO> termConns = (List<TerminalConnectionTO>)
							getConnectionServiceDAO().getTerminalConnections(conn.getConnectionId(), ssoToken).getObject();

						//Get the contact associated with current connection
						ContactTO contact = (ContactTO) 
						getConnectionServiceDAO().getContact(conn.getConnectionId(), ssoToken).getObject();
						
						for(TerminalConnectionTO termConn : termConns)
						{
							//Get the terminal associated with current terminal connection
							TerminalTO term = (TerminalTO) 
								getTerminalConnectionServiceDAO().getTerminal(termConn.getTerminalConnectionId(), ssoToken).getObject();
							termConn.setTerminalName(term.getTerminalName());
							
							StateEventTO stateEventTO = new StateEventTO();
							
							//Check if this terminal is one of ours
							//If it is ours, populate the event object
							if(terminal.getTerminalName().equals(term.getTerminalName()))
							{
								//Supplement the terminal with Connection/TerminalConnection Info								
								ContactTO contactToAdd = contact;
								ConnectionTO connectionToAdd = conn;
								contactToAdd.addConnection(connectionToAdd);
								List<TerminalConnectionTO> termConnsToAdd = termConns;
								
								ConnectionTO connection = contactToAdd.getConnectionById(connectionToAdd.getConnectionId());
								if (connection != null)
									connection.setTerminalConnections(termConnsToAdd);
								
								userContext.addContact(contactToAdd);									
								
								//Add details for all but our own terminal connection
								stateEventTO.setTerminal(terminal.getTerminalName());
								stateEventTO.setAddress(address.getAddressName());
								stateEventTO.setConnection(conn);
								
								StateSummaryTO stateSummary = (StateSummaryTO)getConnectionServiceDAO().getState(conn.getConnectionId(), ssoToken).getObject();
								stateEventTO.setRemoteState(stateSummary.getCurrent());
								
								stateEventTO.setContactId(contact.getContactId());
								stateEventTO.setExternalContactId(contact.getExternalContactId());
								stateEventTO.setTerminalConnection(termConn);
								
								stateSummary = (StateSummaryTO)getTerminalConnectionServiceDAO().getState(termConn.getTerminalConnectionId(), ssoToken).getObject();
								stateEventTO.setLocalState(stateSummary.getCurrent());
								//stateEventTO.setType(((String)getContactServiceDAO()().getconta.getObject());
								
								//Get the connection capabilities
								getCapabilitiesFacade().getCapabilities(conn, ssoToken); 
								stateEventTO.getConnection().setCapabilities(conn.getCapabilities());
								
								//Get the terminalConnecion capabilities
								getCapabilitiesFacade().getCapabilities(termConn, ssoToken);
								stateEventTO.getTerminalConnection().setCapabilities(termConn.getCapabilities());
								
								AddressTO addr = new AddressTO();
								try{
									addr = (AddressTO)getContactServiceDAO().getCallingAddress(
											contact.getContactId(), ssoToken).getObject();
									stateEventTO.setCalling(addr.getAddressName());
								}
								catch(Exception e)
								{
									stateEventTO.setCalling("Can't Get");
								}
								
								addr = new AddressTO();
								try
								{
									addr = (AddressTO)getContactServiceDAO().getCalledAddress(
											contact.getContactId(), ssoToken).getObject();
									stateEventTO.setCalling(addr.getAddressName());
								}
								catch(Exception e)
								{
									stateEventTO.setCalled("Can't Get");
								}
								currentStateEvents.add(stateEventTO);
							}
						}
					}
				}
			}
		}
	}

	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}
	
	/**
	 * @return the notificationDAO
	 */
	public INotificationDAO getNotificationDAO() {
		return notificationDAO;
	}

	/**
	 * @param notificationDAO the notificationDAO to set
	 */
	public void setNotificationDAO(INotificationDAO notificationDAO) {
		this.notificationDAO = notificationDAO;
	}

	/**
	 * @return the capabilitiesFacade
	 */
	public ICapabilitiesFacade getCapabilitiesFacade() {
		return capabilitiesFacade;
	}

	/**
	 * @param capabilitiesFacade the capabilitiesFacade to set
	 */
	public void setCapabilitiesFacade(ICapabilitiesFacade capabilitiesFacade) {
		this.capabilitiesFacade = capabilitiesFacade;
	}

	/**
	 * @return the addressServiceDAO
	 */
	public IAddressServiceDAO getAddressServiceDAO() {
		return addressServiceDAO;
	}

	/**
	 * @param addressServiceDAO the addressServiceDAO to set
	 */
	public void setAddressServiceDAO(IAddressServiceDAO addressServiceDAO) {
		this.addressServiceDAO = addressServiceDAO;
	}

	/**
	 * @return the connectionServiceDAO
	 */
	public IConnectionServiceDAO getConnectionServiceDAO() {
		return connectionServiceDAO;
	}

	/**
	 * @param connectionServiceDAO the connectionServiceDAO to set
	 */
	public void setConnectionServiceDAO(IConnectionServiceDAO connectionServiceDAO) {
		this.connectionServiceDAO = connectionServiceDAO;
	}

	/**
	 * @return the contactServiceDAO
	 */
	public IContactServiceDAO getContactServiceDAO() {
		return contactServiceDAO;
	}

	/**
	 * @param contactServiceDAO the contactServiceDAO to set
	 */
	public void setContactServiceDAO(IContactServiceDAO contactServiceDAO) {
		this.contactServiceDAO = contactServiceDAO;
	}

	/**
	 * @return the terminalConnectionServiceDAO
	 */
	public ITerminalConnectionServiceDAO getTerminalConnectionServiceDAO() {
		return terminalConnectionServiceDAO;
	}

	/**
	 * @param terminalConnectionServiceDAO the terminalConnectionServiceDAO to set
	 */
	public void setTerminalConnectionServiceDAO(
			ITerminalConnectionServiceDAO terminalConnectionServiceDAO) {
		this.terminalConnectionServiceDAO = terminalConnectionServiceDAO;
	}

	
	public IUserServiceDAO getUserServiceDAO() {
		return userServiceDAO;
	}

	public void setUserServiceDAO(IUserServiceDAO userServiceDAO) {
		this.userServiceDAO = userServiceDAO;
	}
	/**
	 * @return the agentTerminalServiceDAO
	 */
	public IAgentTerminalServiceDAO getAgentTerminalServiceDAO() {
		return agentTerminalServiceDAO;
	}

	/**
	 * @param agentTerminalServiceDAO the agentTerminalServiceDAO to set
	 */
	public void setAgentTerminalServiceDAO(
			IAgentTerminalServiceDAO agentTerminalServiceDAO) {
		this.agentTerminalServiceDAO = agentTerminalServiceDAO;
	}

	/**
	 * @return the terminalServiceDAO
	 */
	public ITerminalServiceDAO getTerminalServiceDAO() {
		return terminalServiceDAO;
	}

	/**
	 * @param terminalServiceDAO the terminalServiceDAO to set
	 */
	public void setTerminalServiceDAO(ITerminalServiceDAO terminalServiceDAO) {
		this.terminalServiceDAO = terminalServiceDAO;
	}

	/**
	 * @return the routePointAddressServiceDAO
	 */
	public IRoutePointAddressServiceDAO getRoutePointAddressServiceDAO() {
		return routePointAddressServiceDAO;
	}

	/**
	 * @param routePointAddressServiceDAO the routePointAddressServiceDAO to set
	 */
	public void setRoutePointAddressServiceDAO(
			IRoutePointAddressServiceDAO routePointAddressServiceDAO) {
		this.routePointAddressServiceDAO = routePointAddressServiceDAO;
	}
}
