package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dao.INotificationDAO;

public class CCTLogoutCommand extends Command 
{
	private INotificationDAO notificationDAO;
	private IContactDAO contactDAO;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		if(ssoToken != null)
		{
			// Should execute two SOA calls one after another unsubscribe then 
			// cctLogout in CCTLogoutCommand. Both threads use the same objects 
			// and should not be executed simultaneously.
			getNotificationDAO().unSubscribe(ssoToken);

			//Subscribe for Notifications in a separate thread
			//Thread thread = new Thread(new UnsubscribeHandler());
			//thread.start();
			
			getContactDAO().cctLogout(ssoToken);
			
			ssoToken = null;
		}
	}

/*	
	private class UnsubscribeHandler implements Runnable
	{
		public void run()
		{
			//Unsubscribe for Notifications
			try{
				getNotificationDAO().unSubscribe(ssoToken);
			}
			catch(Exception e)
			{
			}
		}
	}
*/
	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}
	
	/**
	 * @return the notificationDAO
	 */
	public INotificationDAO getNotificationDAO() {
		return notificationDAO;
	}

	/**
	 * @param notificationDAO the notificationDAO to set
	 */
	public void setNotificationDAO(INotificationDAO notificationDAO) {
		this.notificationDAO = notificationDAO;
	}
}
