package com.nortel.rc.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.IAgentServiceDAO;
import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;

public class GetAgentStateCommand extends Command 
{
	private IContactDAO contactDAO;
	private IAgentServiceDAO agentServiceDAO;
	ICapabilitiesFacade capabilitiesFacade;
		
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		boolean allAgentsRequired = false;
		
		List<AgentTO> agents;
		if(params != null && params.get("agent") != null)
		{
			// Get details for single agent
			// Results addition of Agent
			agents = new ArrayList<AgentTO>();
			agents.add((AgentTO)params.get("agent"));				
		}
		else
		{
			// Get all agents for current CCT user
			// Results in collection of AgentTO's
			allAgentsRequired = true;
			agents = (List<AgentTO>)getContactDAO().getAgents(ssoToken);
		}
		
		Map<String, AgentTO> agentMap = new HashMap<String, AgentTO>();
		
		//Get and record the login, ready status, capabilities of each agent
		CallResult cr;
		AgentTO agent = null;
		for(int i=0; i<agents.size(); i++)
		{
			agent = agents.get(i);
			try
			{
				cr = getAgentServiceDAO().isLoggedIn(agent, ssoToken);
				agent.setLoggedIn(((Boolean)cr.getObject()).booleanValue());
			}catch(DAOException daoe)
			{
				agent.setLoggedIn(false);
			}
			
			if(agent.isLoggedIn())
			{
				cr = getAgentServiceDAO().getReadyState(agent, ssoToken);	
				agent.setReady(((Boolean)cr.getObject()).booleanValue());
				
				if(!agent.isReady())
				{
					cr = getAgentServiceDAO().getNotReadyReasonCode(agent, ssoToken);	
					agent.setNotReadyReasonCode((String)cr.getObject());
				}
			}
			
			try
			{
				cr = getAgentServiceDAO().getStaticVoiceTerminal(agent, ssoToken);	
				agent.setStaticVoiceTerminal((TerminalTO)cr.getObject());
			}catch(Exception e)
			{
				
			}
			
			try
			{
				cr = getAgentServiceDAO().getSupervisor(agent, ssoToken);	
				agent.setSupervisor((AgentTO)cr.getObject());
			}catch(Exception e)
			{
				
			}
			
			getCapabilitiesFacade().getCapabilities(agent, ssoToken);
			
			try
			{
				agent.setContactTypes((List<String>)getAgentServiceDAO().getContactTypes(agent, ssoToken).getObject());
			}catch(DAOException daoe)
			{}
			
			agentMap.put(agent.getAgentLoginId(), agent);
		}
			
		if(allAgentsRequired)
		{
			getRefClient().updateAgentContext(agentMap);
		}
		else
		{
			if (agent != null) {
				getRefClient().updateSingleAgentContext(agent);
			}
		}
	}

	/**
	 * @return the contactDAO
	 */
	public IAgentServiceDAO getAgentServiceDAO() {
		return agentServiceDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setAgentServiceDAO(IAgentServiceDAO agentServiceDAO) {
		this.agentServiceDAO = agentServiceDAO;
	}
	
	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}

	/**
	 * @return the capabilitiesFacade
	 */
	public ICapabilitiesFacade getCapabilitiesFacade() {
		return capabilitiesFacade;
	}

	/**
	 * @param capabilitiesFacade the capabilitiesFacade to set
	 */
	public void setCapabilitiesFacade(ICapabilitiesFacade capabilitiesFacade) {
		this.capabilitiesFacade = capabilitiesFacade;
	}
}
