package com.nortel.rc.command;

import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dto.IntrinsicTO;

public class SetIntrinsicDataSessionServiceCommand extends Command 
{
	private IContactDAO contactDAO;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		List<IntrinsicTO> data = (List<IntrinsicTO>)params.get("intrinsicData");
		getContactDAO().setIntrinsicData((String)params.get("contactId"), data, ssoToken);	
	}

	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}
}