package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IAgentTerminalServiceDAO;
import com.nortel.rc.dto.TerminalTO;

public class SetIsNotReadyCommand extends Command 
{
	private IAgentTerminalServiceDAO agentTerminalServiceDAO;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		TerminalTO terminal = (TerminalTO)params.get("terminal");
		
		if(terminal.getTerminalNotReadyReason() != null && !terminal.getTerminalNotReadyReason().equals(""))
		{	
			getAgentTerminalServiceDAO().setNotReadyReasonCode(terminal, ssoToken);
		}
		else
		{
			getAgentTerminalServiceDAO().setIsReady(terminal, false, ssoToken);
		}
	}

	/**
	 * @return the agentTerminalServiceDAO
	 */
	public IAgentTerminalServiceDAO getAgentTerminalServiceDAO() {
		return agentTerminalServiceDAO;
	}

	/**
	 * @param agentTerminalServiceDAO the agentTerminalServiceDAO to set
	 */
	public void setAgentTerminalServiceDAO(
			IAgentTerminalServiceDAO agentTerminalServiceDAO) {
		this.agentTerminalServiceDAO = agentTerminalServiceDAO;
	}
	
}
