package com.nortel.rc.dao;

import java.net.URL;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.agentterminalservice.AgentTerminalService;
import com.nortel.soa.oi.cct.agentterminalservice.SOAOICCTAgentTerminalService;
import com.nortel.soa.oi.cct.faults.GetCapabilitiesException;
import com.nortel.soa.oi.cct.types.AgentTerminalCapabilities;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalType;
import com.nortel.soa.oi.cct.types.agentterminalservice.BooleanTerminalRequest;
import com.nortel.soa.oi.cct.types.agentterminalservice.GetActivityCodeResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.GetAgentTerminalCapabilitiesResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.GetDoNotDisturbResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.GetLoginIdResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.IsForwardedResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.IsReadyResponse;
import com.nortel.soa.oi.cct.types.agentterminalservice.StringTerminalRequest;
import com.nortel.soa.oi.cct.types.agentterminalservice.TerminalRequest;

public class AgentTerminalServiceDAO extends ServiceDAO implements IAgentTerminalServiceDAO
{	
	private static Logger logger = Logger.getLogger("rc.dao.AgentTerminalServiceDAO");
	private String endPoint = null;
    
    public CallResult getCapabilities(TerminalTO term, String sso) throws DAOException
    {
    	String methodName = "getCapabilities():";
    	TerminalRequest agentTerminalRequest = new TerminalRequest();
        AgentTerminalCapabilities capabilities = null;
	    SsoToken ssoToken = new SsoToken();
	    Terminal terminal = new Terminal();
	    
	    terminal.setTerminalName(term.getTerminalName());
	    terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
	    ssoToken.setToken(sso);
	    
	    agentTerminalRequest.setTerminal(terminal);
	    agentTerminalRequest.setSsoToken(ssoToken);

	    try {
	    	GetAgentTerminalCapabilitiesResponse response = getPort().getCapabilities(agentTerminalRequest);
	    	
	    	if (response == null)
	    		throw new GetCapabilitiesException("NULL response received");

	        capabilities = response.getTerminalCapabilities();
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    com.nortel.rc.dto.AgentTerminalCapabilitiesTO caps = new com.nortel.rc.dto.AgentTerminalCapabilitiesTO();
	    caps.setCanGetActivityCode(capabilities.isCanGetActivityCode());
	    caps.setCanGetNotReadyReason(capabilities.isCanGetNotReadyReason());
	    caps.setCanGetReadyStatus(capabilities.isCanGetReadyStatus());
	    caps.setCanLogin(capabilities.isCanLogin());
	    caps.setCanLogout(capabilities.isCanLogout());
	    caps.setCanSetActivityCode(capabilities.isCanSetActivityCode());
	    caps.setCanSetNotReadyReason(capabilities.isCanSetNotReadyReason());
	    caps.setCanSetReadyStatus(capabilities.isCanSetReadyStatus());
	    
	    CallResult result = new CallResult();
	    result.setObject(caps);
        return result;
    }
    
    public CallResult isLoggedIn(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "isLoggedIn():";
    	TerminalRequest request = new TerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    
	    GetLoginIdResponse response = null;
	    CallResult result = new CallResult();
	    
	    try {       	
	    	response = getPort().getLoginId(request);
	
	    } catch (Exception e) {
	    	result.setObject(false);
	    	logExecption(logger, methodName, e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    result.setObject(response != null && response.getLoginId() != null ? true : false);
        return result;
    }
    
    public CallResult isForwarded(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "isForwarded():";
    	TerminalRequest request = new TerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    
	    IsForwardedResponse response = null;
	    
	    try {       	
	    	response = getPort().isForwarded(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(response != null ? response.isIsForwarded() : false);
        return result;
    }
    
    public CallResult getDoNotDisturb(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "getDoNotDisturb():";
    	TerminalRequest request = new TerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    
	    GetDoNotDisturbResponse response = null;
	    
	    try {       	
	    	response = getPort().getDoNotDisturb(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(response != null ? response.isDoNotDisturb() : false);
        return result;
    }
    
    public CallResult isReady(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "isReady():";
    	TerminalRequest request = new TerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    
	    IsReadyResponse response = null;
	    CallResult result = new CallResult();
	    
	    try {       	
	    	response = getPort().isReady(request);
	
	    } catch (Exception e) {
	    	result.setObject(false);
	    	logExecption(logger, methodName, e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    result.setObject(response != null ? response.isIsReady() : false);
        return result;
    }
    
    public CallResult getActivityCode(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "getActivityCode():";
    	TerminalRequest request = new TerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    
	    GetActivityCodeResponse response = null;
	    
	    try {       	
	    	response = getPort().getActivityCode(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    result.setMessage(response != null ? response.getActivityCode() : null);
        return result;
    }
    
    public CallResult setIsReady(TerminalTO term, boolean ready, String sso) throws DAOException
    {  
    	String methodName = "setIsReady():";
    	BooleanTerminalRequest request = new BooleanTerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    request.setValue(ready);
	    
	    try {       	
	    	getPort().setIsReady(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
        return null;
    }
    
    public CallResult setNotReadyReasonCode(TerminalTO term, String sso) throws DAOException
    {  
    	String methodName = "setNotReadyReasonCode():";
    	StringTerminalRequest request = new StringTerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    request.setValue(term.getTerminalNotReadyReason());
	    
	    try {       	
	    	getPort().setNotReadyReasonCode(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
        return null;
    }
    
    public CallResult getLoginId(TerminalTO term, String sso) throws DAOException {
    	String methodName = "getLoginId():";
    	TerminalRequest request = new TerminalRequest();
	    Terminal terminal = new Terminal();
	    SsoToken ssoToken = new SsoToken();	    
	    
		terminal.setTerminalType(TerminalType.valueOf(term.getTerminalType()));
		terminal.setTerminalName(term.getTerminalName());	    
	    ssoToken.setToken(sso);
	    
	    request.setTerminal(terminal);
	    request.setSsoToken(ssoToken);
	    
	    GetLoginIdResponse response = null;
	    CallResult result = new CallResult();
	    
	    try {       	
	    	response = getPort().getLoginId(request);
	
	    } catch (Exception e) {
	    	result.setObject(false);
	    	logExecption(logger, methodName, e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    result.setObject(response != null && response.getLoginId() != null ? response.getLoginId() : "");
        return result;
	}
    
    /**
   	 * @return {@link AgentTerminalService}
   	 * Retrieves interface to be used by service consumers
   	 */
   	public AgentTerminalService getPort() throws DAOException
   	{
   		if(endPoint == null)
   		{	      
   			SOAOICCTAgentTerminalService ss = new SOAOICCTAgentTerminalService(getWsdlUrl(), getServiceQName());
   			URL wsdlDoc = ss.getWSDLDocumentLocation();
   			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
   		}
   		
   		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
   		factory.setServiceClass(AgentTerminalService.class);
   		AgentTerminalService service = (AgentTerminalService) factory.create();
   		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);

   		return service;
   	}

}
