package com.nortel.rc.dao;

import java.util.List;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.AttachedDataTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.IntrinsicTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;

public interface IContactDAO extends IServiceDAO
{
	public CallResult loginAgent(TerminalTO terminal, String uname, String pwd, String sso)
			throws DAOException;
	
	public CallResult loginAgentToTerminal(TerminalTO terminal, AgentTO agent, int state, String sso)
			throws DAOException;
	
	public CallResult logoutAgentFromTerminal(TerminalTO terminal, String sso)
		throws DAOException;	
	
	public CallResult loginAgentToState(TerminalTO terminal, AgentTO agent, int state, String sso)
			throws DAOException;
	
	public CallResult logoutAgent(TerminalTO terminal, String sso)
			throws DAOException;
	
	public CallResult createContact(TerminalTO terminal, AddressTO sourceAddress, AddressTO destAddress, String ssoToken)
			throws DAOException;
	
	public CallResult getContact(String externalContactId, String sso)
			throws DAOException;
	
	public CallResult initiateSupervisedTransfer(TerminalTO term, AddressTO dest, String contactId, String sso)
			throws DAOException;
	
	public CallResult completeSupervisedTransfer(TerminalTO term, String consultedContactId, String contactId, String sso)
			throws DAOException;
	
	public CallResult transferContact(TerminalTO terminal, AddressTO dest, String contactId, String sso)
			throws DAOException;
	
	public CallResult initiateConference(TerminalTO terminal, AddressTO dest, String contactId, String sso)
			throws DAOException;
	
	public CallResult completeConference(TerminalTO terminal, String consultedContactId, String contactId, String sso)
			throws DAOException;

	public CallResult answerContact(String contactId, TerminalTO terminal, String ssoToken)
			throws DAOException;

	public CallResult holdContact(String contactId, TerminalTO terminal, String ssoToken)
			throws DAOException;

	public CallResult unHoldContact(String contactId, TerminalTO terminal, String ssoToken)
			throws DAOException;
	
	public CallResult dropContact(String contactId, TerminalTO terminal, String ssoToken)
			throws DAOException;
	
	public CallResult cctLogin(String uname, String pwd, String domain) 
			throws DAOException;
	
    public CallResult cctLogout(String ssoToken)
    		throws DAOException;
    
    public CallResult emergencyKey(String contactId, TerminalTO terminal, String ssoToken)
			throws DAOException;
    
    public CallResult callSupervisor(TerminalTO terminal, AddressTO address, String ssoToken)
			throws DAOException;
    
    public CallResult setToReadyState(TerminalTO terminal, String sso)
		throws DAOException;
    
    public CallResult setToNotReadyState(TerminalTO terminal, String sso)
		throws DAOException;
    
    public CallResult setToNotReadyStateWithReasonCode(TerminalTO terminal, String sso)
    	throws DAOException;
    
    public CallResult makeSetBusy(TerminalTO terminal, String sso)
		throws DAOException;
    
    public List<TerminalTO> getUserTerminals(String ssoToken)
    		throws DAOException;
    
    public List<AddressTO> getTerminalAddresses(TerminalTO terminal, String ssoToken)
    		throws DAOException;
    
    public List<AddressTO> getUserAddresses(String ssoToken)
    		throws DAOException;
    
    public List<AgentTO> getAgents(String ssoToken)
			throws DAOException;
    
    public CallResult setActivityCode(TerminalTO term, String sso)
    		throws DAOException;
    
    public CallResult generateDTMF(TerminalTO term, ContactTO cont, String digits, String sso)
    		throws DAOException;
    
    public CallResult getContactData(String contactId, String sso)
    		throws DAOException;
    
    public CallResult setContactData(String contactId, AttachedDataTO dataToAttach, String sso)
    		throws DAOException;
    
    public CallResult setIntrinsicData(String contactId, List<IntrinsicTO> data, String sso)
		throws DAOException;

	public CallResult getIntrinsicData(String contactId, String sso)
		throws DAOException;
}
